<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method deleteByParams(array $params)
 * @method itemsByParams(array $params)
 */
class OfflineDisburseRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  int $store_id 门店ID [ require false ]
     * @support  int $goods_id 支出项ID [ require false ]
     * @support  string $start_time 起始时间 [ require false ]
     * @support  string $end_time 结束时间 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  string $pay_type 付款类型 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 详情
     *
     * @support  int $id 线下支出记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 创建
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $item_id 支出项ID [ require true ]
     * @support  float $money 金额 [ require true ]
     * @support  string $take_people 取款人 [ require true ]
     * @support  string $pay_type 付款类型 [ require true ]
     * @support  array $certificates 凭证（图片url） [ require true ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 删除
     *
     * @support  int $id 线下支出记录ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * todo:就只能返回array
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function items () {
        return self::getClass()->items();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OfflineDisburseRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OfflineDisburseRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}