<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailBySkuByParams(array $params)
 * @method getStoreGroupListByParams(array $params)
 * @method getAllRetailProductByParams(array $params)
 * @method getAllCustomizationProductByParams(array $params)
 * @method getProductListByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据sku获取产品详情
     *
     * @param  int $id sku id [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailBySku (int $id, bool $withOffSku = false) {
        return self::getClass()->detailBySku([
            "id" => $id,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取城市组列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreGroupList () {
        return self::getClass()->getStoreGroupList();
    }

    /**
     * 获取全部零售产品
     *
     * @support  array $ids 渠道productSkuId数组 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  array $categoryIds 销售渠道productSkuId数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  string $skuCode 销售渠道skuCode [ require false ]
     * @support  bool $isOnlyShelveUp true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllRetailProduct () {
        return self::getClass()->getAllRetailProduct([
        ]);
    }

    /**
     * 获取全部定制类型零售产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllCustomizationProduct () {
        return self::getClass()->getAllCustomizationProduct();
    }

    /**
     * 查询零售产品列表
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  array $sku_ids sku_ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductList () {
        return self::getClass()->getProductList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}