<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCloseOrderByParams(array $params)
 * @method firstClickByParams(array $params)
 * @method icbcPhotoByParams(array $params)
 * @method afterRefundByParams(array $params)
 * @method orderCompleteByParams(array $params)
 * @method sendKfMessageByParams(array $params)
 * @method sendRetailKfMessageByParams(array $params)
 * @method sendKidsMessageByParams(array $params)
 * @method sendMantuXxzMessageByParams(array $params)
 * @method paySuccessSendNoticeByParams(array $params)
 * @method sendNormalNotifyByParams(array $params)
 * @method sendMessageByParams(array $params)
 * @method sendKfStoreQrMessageByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 关闭订单
     *
     * @param  array $orderObject 订单数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCloseOrder (array $orderObject) {
        return self::getClass()->hookCloseOrder([
            "orderObject" => $orderObject,
        ]);
    }

    /**
     * 第一次进入支付链接(仅限拍摄订单)
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function firstClick (string $orderNum) {
        return self::getClass()->firstClick([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * icbc真我卡获取云端原片地址
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  string[]
     */
    public static function icbcPhoto () {
        return self::getClass()->icbcPhoto([
        ]);
    }

    /**
     * 退款完成推送通知
     *
     * @support  int $refundId refund id [ require true ]
     * @support  float $oldRefundMoney 需要扣除的退款金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function afterRefund () {
        return self::getClass()->afterRefund([
        ]);
    }

    /**
     * 订单完成推送通知
     *
     * @support  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderComplete () {
        return self::getClass()->orderComplete([
        ]);
    }

    /**
     * 婚礼照推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendKfMessage () {
        return self::getClass()->sendKfMessage([
        ]);
    }

    /**
     * 零售客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendRetailKfMessage () {
        return self::getClass()->sendRetailKfMessage([
        ]);
    }

    /**
     * 小幸运kids营销推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendKidsMessage () {
        return self::getClass()->sendKidsMessage([
        ]);
    }

    /**
     * 缦图形象照客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMantuXxzMessage () {
        return self::getClass()->sendMantuXxzMessage([
        ]);
    }

    /**
     * 支付成功推送
     *
     * @support  array $wxData 微信发送参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function paySuccessSendNotice () {
        return self::getClass()->paySuccessSendNotice([
        ]);
    }

    /**
     * 看片通知
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $type 类型 [ require false ]
     * @support  bool $can_store_look_photo 是否可以预约门店看片 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNormalNotify () {
        return self::getClass()->sendNormalNotify([
        ]);
    }

    /**
     * 推送客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  array $message_text 文字消息 [ require false ]
     * @support  array $image_media 图片消息 [ require false ]
     * @support  array $article_media 图文消息 [ require false ]
     * @support  array $rule 消息规则 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMessage () {
        return self::getClass()->sendMessage([
        ]);
    }

    /**
     * 推送客服消息
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $media_id 图片media_id信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfStoreQrMessage (int $user_id, string $media_id) {
        return self::getClass()->sendKfStoreQrMessage([
            "user_id" => $user_id,
            "media_id" => $media_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}