<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-21 16:44:06
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderDiff
 */
class OrderDiff {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\OrderDiff";

    /**
     * 创建一个订单修改(订单完成前)
     * @return  mixed
    */
    public static function create (int $orderId, int $userId, string $userName, string $userPhone, string $userSex, string $userBirthday, float $money, float $realMoney, float $needPaidMoney, array $productInfo, int $reachedPeopleNum, string $interiorCouponCode, float $interiorCouponDeductionMoney, int $couponId, float $couponDeductionMoney, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, string $discountType, string $discountNote, int $specialDiscountStaffId, string $reserveTime, string $type, string $note, string $module = 'himo', array $retailProducts, array $packageDiscountIds, float $packageDiscountMoney, float $weekdayDiscountMoney, bool $isChangeStore = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "userId" => $userId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "money" => $money, "realMoney" => $realMoney, "needPaidMoney" => $needPaidMoney, "productInfo" => $productInfo, "reachedPeopleNum" => $reachedPeopleNum, "interiorCouponCode" => $interiorCouponCode, "interiorCouponDeductionMoney" => $interiorCouponDeductionMoney, "couponId" => $couponId, "couponDeductionMoney" => $couponDeductionMoney, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "discountType" => $discountType, "discountNote" => $discountNote, "specialDiscountStaffId" => $specialDiscountStaffId, "reserveTime" => $reserveTime, "type" => $type, "note" => $note, "module" => $module, "retailProducts" => $retailProducts, "packageDiscountIds" => $packageDiscountIds, "packageDiscountMoney" => $packageDiscountMoney, "weekdayDiscountMoney" => $weekdayDiscountMoney, "isChangeStore" => $isChangeStore]);
    }
    /**
     * 设置diff订单完成支付
     * @return  mixed
    */
    public static function setPaid (int $orderId, int $orderDiffId, string $diffType, string $payType, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "diffType" => $diffType, "payType" => $payType, "paymentNo" => $paymentNo]);
    }
    /**
     * 获取diff详情
     * @return  mixed
    */
    public static function detail (int $orderDiffId, string $diffType, bool $showCancel) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderDiffId" => $orderDiffId, "diffType" => $diffType, "showCancel" => $showCancel]);
    }
    /**
     * 取消未支付订单
     * @return  mixed
    */
    public static function cancel (int $orderId, int $orderDiffId, string $reason, string $diffType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "reason" => $reason, "diffType" => $diffType]);
    }
    /**
     * 完成订单之后添加加修加印产品
     * @return  mixed
    */
    public static function createUpgradeSku (int $orderId, float $money, float $realMoney, array $productInfo, int $couponId, float $couponDeductionMoney, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, string $discountType, string $discountNote, int $specialDiscountStaffId, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUpgradeSku(["orderId" => $orderId, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "couponId" => $couponId, "couponDeductionMoney" => $couponDeductionMoney, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "discountType" => $discountType, "discountNote" => $discountNote, "specialDiscountStaffId" => $specialDiscountStaffId, "inputStaffId" => $inputStaffId]);
    }
    /**
     * 订单Diff支付成功回调
     * @return  mixed
    */
    public static function orderDiffSuccessHook (\Mainto\Bridge\Structs\HimoProduct\Order\Message\Cmd\OrderModifyOrderSaleCmd $orderModifyOrderSaleCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderDiffSuccessHook($orderModifyOrderSaleCmd);
    }
    /**
     * 订单Diff支付失败回调
     * @return  mixed
    */
    public static function orderDiffCancelHook (\Mainto\Bridge\Structs\HimoProduct\Order\Message\Cmd\OrderModifyCancelCmd $orderModifyCancelCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderDiffCancelHook($orderModifyCancelCmd);
    }
    /**
     * 通过orderDiffId获取转门店后的新orderId
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetNewOrderIdByOrderDiffIdDto
    */
    public static function getNewOrderIdByOrderDiffId (int $orderDiffId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getNewOrderIdByOrderDiffId(["orderDiffId" => $orderDiffId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetNewOrderIdByOrderDiffIdDto"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}