<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-17 14:43:13
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GuestPhotoPool
 */
class GuestPhotoPool {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GuestPhotoPool";

    /**
     * 客片池详情
     * @return  mixed
    */
    public static function photoDetail (int $photoId, string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->photoDetail(["photoId" => $photoId, "streamNum" => $streamNum]);
    }
    /**
     * 点赞/点踩
     * @return  bool
    */
    public static function operationPhoto (int $photoId, string $operationType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operationPhoto(["photoId" => $photoId, "operationType" => $operationType]);
    }
    /**
     * 看片完成时批量保存客片
     * @return  mixed
    */
    public static function saveGuestPhoto (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveGuestPhoto(["orderNum" => $orderNum]);
    }
    /**
     * 摄影上传时保存客片
     * @return  mixed
    */
    public static function saveGuestPhotoByUpload (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveGuestPhotoByUpload(["orderNum" => $orderNum]);
    }
    /**
     * hook流水－摄影问题标签
     * @return  mixed
    */
    public static function bmsHookStreamProblemTagPhotography (string $streamNum, int $photoCount, array $tags) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsHookStreamProblemTagPhotography(["streamNum" => $streamNum, "photoCount" => $photoCount, "tags" => $tags]);
    }
    /**
     * hook流水－化妆问题标签
     * @return  mixed
    */
    public static function bmsHookStreamProblemTagMakeup (string $streamNum, int $photoCount, array $tags, int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsHookStreamProblemTagMakeup(["streamNum" => $streamNum, "photoCount" => $photoCount, "tags" => $tags, "streamId" => $streamId]);
    }
    /**
     * 客片池列表
     * @return  mixed
    */
    public static function getPhotoList (string $startTime, string $endTime, string $orderNum, array $photoType, string $userName, string $phone, array $storeIds, array $productIds, array $staffs, array $staffInfo, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoList(["startTime" => $startTime, "endTime" => $endTime, "orderNum" => $orderNum, "photoType" => $photoType, "userName" => $userName, "phone" => $phone, "storeIds" => $storeIds, "productIds" => $productIds, "staffs" => $staffs, "staffInfo" => $staffInfo, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 根据当前图片找到相似图片
     * @return  mixed
    */
    public static function getSimilarByImg (string $img_url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSimilarByImg(["img_url" => $img_url]);
    }
    /**
     * 根据当前图片地址找到对应订单
     * @return  mixed
    */
    public static function getOrderDetailByImg (string $img_url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetailByImg(["img_url" => $img_url]);
    }
    /**
     * 获取上传签名
     * @return  string
    */
    public static function getUploadToken () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUploadToken();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}