<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 22:25:22
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Staff";

    /**
     * 获取员工列表
     * @return  mixed
    */
    public static function list (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["store_id" => $store_id]);
    }
    /**
     * 根据分类获取门店成员列表
     * @return  mixed
    */
    public static function storeStaff (int $store_id, string $staff_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeStaff(["store_id" => $store_id, "staff_type" => $staff_type]);
    }
    /**
     * 兼岗确认添加对应门店权限
     * @return  bool
    */
    public static function staffPluralismConfirm (int $pluralism_store_id, int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismConfirm(["pluralism_store_id" => $pluralism_store_id, "staff_id" => $staff_id]);
    }
    /**
     * 兼岗结束删除对应门店权限
     * @return  bool
    */
    public static function staffPluralismStop (int $pluralism_store_id, int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismStop(["pluralism_store_id" => $pluralism_store_id, "staff_id" => $staff_id]);
    }
    /**
     * 伙伴更新
     * @return  bool
    */
    public static function staffChangeDepartment (array $old_staff, array $new_staff) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffChangeDepartment(["old_staff" => $old_staff, "new_staff" => $new_staff]);
    }
    /**
     * 获取技术专家列表
     * @return  mixed
    */
    public static function getTechnologistList (string $name, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTechnologistList(["name" => $name, "type" => $type]);
    }
    /**
     * 通过姓名或花名获取伙伴
     * @return  mixed
    */
    public static function getStaffByRealOrNickName (int $technologistId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByRealOrNickName(["technologistId" => $technologistId, "name" => $name]);
    }
    /**
     * 技术专家关联督导
     * @return  bool
    */
    public static function assignSupervisor (int $technologist_id, array $supervisor_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignSupervisor(["technologist_id" => $technologist_id, "supervisor_ids" => $supervisor_ids]);
    }
    /**
     * 通过技术专家获取督导
     * @return  mixed
    */
    public static function getSupervisorByTechnologist (array $technologist_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupervisorByTechnologist(["technologist_ids" => $technologist_ids]);
    }
    /**
     * 获取专家关联信息
     * @return  mixed
    */
    public static function getStaffRelation (array $technologist_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRelation(["technologist_ids" => $technologist_ids]);
    }
    /**
     * 根据分类获取门店成员列表
     * @return  mixed
    */
    public static function getStaffByType (array $storeIds, string $staffType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByType(["storeIds" => $storeIds, "staffType" => $staffType]);
    }
    /**
     * 查询员工id
     * @return  array
    */
    public static function queryStaff (string $nameOrNickname, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryStaff(["nameOrNickname" => $nameOrNickname, "phone" => $phone]);
    }
    /**
     * 根据门店获取岗位
     * @return  array
    */
    public static function getPositions (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPositions(["storeIds" => $storeIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}