<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 22:25:22
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Invoice
 */
class Invoice {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Invoice";

    /**
     * 开具发票
     * @return  bool
    */
    public static function create (string $invoice_belong, string $invoice_type, string $title_type, string $type, bool $is_now, string $name, string $phone, string $taxnum, array $order_nums, array $detail, string $telephone, string $address, string $account, string $email, string $message, string $delivery_area, string $delivery_address, string $delivery_people, string $delivery_phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["invoice_belong" => $invoice_belong, "invoice_type" => $invoice_type, "title_type" => $title_type, "type" => $type, "is_now" => $is_now, "name" => $name, "phone" => $phone, "taxnum" => $taxnum, "order_nums" => $order_nums, "detail" => $detail, "telephone" => $telephone, "address" => $address, "account" => $account, "email" => $email, "message" => $message, "delivery_area" => $delivery_area, "delivery_address" => $delivery_address, "delivery_people" => $delivery_people, "delivery_phone" => $delivery_phone]);
    }
    /**
     * 开具发票(RPC调用)
     * @return  bool
    */
    public static function createInvoice (string $invoice_belong, string $invoice_type, string $title_type, string $type, bool $is_now, string $name, string $phone, string $taxnum, array $order_nums, array $detail, string $telephone, string $address, string $account, string $email, string $message, string $delivery_area, string $delivery_address, string $delivery_people, string $delivery_phone, int $staff_id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createInvoice(["invoice_belong" => $invoice_belong, "invoice_type" => $invoice_type, "title_type" => $title_type, "type" => $type, "is_now" => $is_now, "name" => $name, "phone" => $phone, "taxnum" => $taxnum, "order_nums" => $order_nums, "detail" => $detail, "telephone" => $telephone, "address" => $address, "account" => $account, "email" => $email, "message" => $message, "delivery_area" => $delivery_area, "delivery_address" => $delivery_address, "delivery_people" => $delivery_people, "delivery_phone" => $delivery_phone, "staff_id" => $staff_id, "store_id" => $store_id]);
    }
    /**
     * 重新开具发票(RPC调用)
     * @return  bool
    */
    public static function reopen (int $invoice_id, string $invoice_belong, string $title_type, bool $is_now, string $name, string $phone, string $taxnum, array $order_nums, array $detail, string $telephone, string $address, string $account, string $email, string $message, string $delivery_area, string $delivery_address, string $delivery_people, string $delivery_phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reopen(["invoice_id" => $invoice_id, "invoice_belong" => $invoice_belong, "title_type" => $title_type, "is_now" => $is_now, "name" => $name, "phone" => $phone, "taxnum" => $taxnum, "order_nums" => $order_nums, "detail" => $detail, "telephone" => $telephone, "address" => $address, "account" => $account, "email" => $email, "message" => $message, "delivery_area" => $delivery_area, "delivery_address" => $delivery_address, "delivery_people" => $delivery_people, "delivery_phone" => $delivery_phone]);
    }
    /**
     * 电子发票详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 电子发票详情(直接返回前端需要的数据格式)
     * @return  mixed
    */
    public static function detailRefit (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailRefit(["id" => $id]);
    }
    /**
     * 电子发票删除
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 设置开票完成状态
     * @return  mixed
    */
    public static function complete (bool $is_electronic, int $id, string $delivery_company, int $delivery_id, bool $pass, array $complete_extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->complete(["is_electronic" => $is_electronic, "id" => $id, "delivery_company" => $delivery_company, "delivery_id" => $delivery_id, "pass" => $pass, "complete_extend" => $complete_extend]);
    }
    /**
     * 电子发票列表
     * @return  mixed
    */
    public static function list (bool $is_electronic, string $order_no, string $invoke_type, string $service_type, string $start_time, string $end_time, string $status, string $title, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["is_electronic" => $is_electronic, "order_no" => $order_no, "invoke_type" => $invoke_type, "service_type" => $service_type, "start_time" => $start_time, "end_time" => $end_time, "status" => $status, "title" => $title, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 定时检查并重开发票
     * @return  bool
    */
    public static function cronSubmitFinalCommit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSubmitFinalCommit();
    }
    /**
     * 发票作废(电子票会开红票)
     * @return  bool
    */
    public static function invalid (int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->invalid(["invoice_id" => $invoice_id]);
    }
    /**
     * 发票审核不通过
     * @return  bool
    */
    public static function reviewFailed (int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewFailed(["invoice_id" => $invoice_id]);
    }
    /**
     * 电子发票重新发送
     * @return  bool
    */
    public static function resend (int $invoice_id, string $phone = '', string $email = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->resend(["invoice_id" => $invoice_id, "phone" => $phone, "email" => $email]);
    }
    /**
     * 可开发票订单列表
     * @return  mixed
    */
    public static function invoiceList (string $phone, string $order_no, bool $invoiced, int $store_id, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->invoiceList(["phone" => $phone, "order_no" => $order_no, "invoiced" => $invoiced, "store_id" => $store_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 开票主体门店
     * @return  mixed
    */
    public static function invoiceSubject () {
        return RpcClass::getClass(self::$serviceName, self::$className)->invoiceSubject();
    }
    /**
     * 各类订单可开发票订单列表
     * @return  mixed
    */
    public static function canInvoiceList (string $phone, string $order_no, string $type, int $store_id, bool $invoiced, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canInvoiceList(["phone" => $phone, "order_no" => $order_no, "type" => $type, "store_id" => $store_id, "invoiced" => $invoiced, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}