<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-02 16:37:12
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Auth
 */
class Auth {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Auth";

    /**
     * 获取管理员信息
     * @return  array
    */
    public static function staffInfo (string $staffName, string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffInfo(["staffName" => $staffName, "type" => $type]);
    }
    /**
     * 获取当前门店
     * @return  int
    */
    public static function currentStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->currentStore();
    }
    /**
     * 设置当前门店
     * @return  int
    */
    public static function selectStore (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->selectStore(["store_id" => $store_id]);
    }
    /**
     * 获取加盟商信息
     * @return  mixed
    */
    public static function affiliateInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->affiliateInfo();
    }
    /**
     * 获取kids系统权限列表
     * @return  array
    */
    public static function getKidsAuthList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getKidsAuthList();
    }
    /**
     * bmsApp 持久化登陆
     * @return  int
    */
    public static function login (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->login(["code" => $code]);
    }
    /**
     * bmsApp 退出
     * @return  mixed
    */
    public static function logOut (string $deviceUniqueNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logOut(["deviceUniqueNo" => $deviceUniqueNo]);
    }
    /**
     * 获取 App 持久化 Code
     * @return  string
    */
    public static function getLoginCode (string $deviceUniqueNo, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLoginCode(["deviceUniqueNo" => $deviceUniqueNo, "extend" => $extend]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}