<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-08 15:09:09
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GroupOrder
 */
class GroupOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GroupOrder";

    /**
     * 团购订单列表
     * @return  mixed
    */
    public static function list (string $business_name, string $user_name, string $user_phone, array $order_ids, string $order_no, string $status, int $is_private_pay, int $is_installment, string $installment_status, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["business_name" => $business_name, "user_name" => $user_name, "user_phone" => $user_phone, "order_ids" => $order_ids, "order_no" => $order_no, "status" => $status, "is_private_pay" => $is_private_pay, "is_installment" => $is_installment, "installment_status" => $installment_status, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 团购订单列表
     * @return  mixed
    */
    public static function listWithParams (array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithParams(["params" => $params]);
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detail (int $id, string $group_order_type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "group_order_type" => $group_order_type]);
    }
    /**
     * 根据支付方式获取订单列表
     * @return  mixed
    */
    public static function getListByPay (string $pay_type, string $paid_at_start, string $paid_at_end, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPay(["pay_type" => $pay_type, "paid_at_start" => $paid_at_start, "paid_at_end" => $paid_at_end, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 团购订单详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrder\DTO\GroupOrderDetailDTO
    */
    public static function groupOrderDetail (string $groupOrderNo, string $groupOrderType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->groupOrderDetail(["groupOrderNo" => $groupOrderNo, "groupOrderType" => $groupOrderType]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrder\DTO\GroupOrderDetailDTO"
        );
    }
    /**
     * 财务修改支付方式
     * @return  bool
    */
    public static function changePayType (int $id, int $payId, string $payType, string $paymentNo = '', string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payId" => $payId, "payType" => $payType, "paymentNo" => $paymentNo, "reason" => $reason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}