<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-07 12:07:28
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Application
 */
class Application {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Application";

    /**
     * 创建应用
     * @return  mixed
    */
    public static function createOrEditApp (string $appNo, string $appName, string $appMd5, string $asarDownUrl, string $appIcon, string $backgroundUrl, string $themeColor) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrEditApp(["appNo" => $appNo, "appName" => $appName, "appMd5" => $appMd5, "asarDownUrl" => $asarDownUrl, "appIcon" => $appIcon, "backgroundUrl" => $backgroundUrl, "themeColor" => $themeColor]);
    }
    /**
     * 获取应用详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationDto
    */
    public static function getAppDetail (string $appNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAppDetail(["appNo" => $appNo]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationDto"
        );
    }
    /**
     * 获取应用列表(全部)
     * @return  array
    */
    public static function getAppList (string $status) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAppList(["status" => $status]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationDto[]"
        );
    }
    /**
     * 获取应用列表(分页)
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationPageDto
    */
    public static function getAppListByPage (int $page, int $pageSize, string $status) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAppListByPage(["page" => $page, "pageSize" => $pageSize, "status" => $status]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationPageDto"
        );
    }
    /**
     * 下架应用
     * @return  bool
    */
    public static function deleteApp (string $appNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteApp(["appNo" => $appNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}