<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-28 14:31:30
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCardTemplate
 */
class ProductCardTemplate {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductCardTemplate";

    /**
     * 创建
     * @return  int
    */
    public static function create (string $name, array $limit, string $apply_in = 'himo', array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "limit" => $limit, "apply_in" => $apply_in, "extend" => $extend]);
    }
    /**
     * 更新
     * @return  bool
    */
    public static function update (int $id, string $name, array $limit, bool $special, bool $action_scope, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "limit" => $limit, "special" => $special, "action_scope" => $action_scope, "extend" => $extend]);
    }
    /**
     * 获取产品卡模板列表(分页)
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\TemplateListDto
    */
    public static function list (int $template_id, string $name, string $type, int $page, string $apply_in = 'himo', int $page_size, int $create_by) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list(["template_id" => $template_id, "name" => $name, "type" => $type, "page" => $page, "apply_in" => $apply_in, "page_size" => $page_size, "create_by" => $create_by]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\TemplateListDto"
        );
    }
    /**
     * 获取产品卡模板列表(所有)
     * @return  array
    */
    public static function all (string $name, string $apply_in = 'himo') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->all(["name" => $name, "apply_in" => $apply_in]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\TemplateDto[]"
        );
    }
    /**
     * 产品卡模板详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\TemplateDto
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\TemplateDto"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}