<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-17 13:49:39
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductPackage
 */
class ProductPackage {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductPackage";

    /**
     * 创建套餐
     * @return  mixed
    */
    public static function createPackage (string $module, string $name, string $engName, array $extend, array $metadata) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPackage(["module" => $module, "name" => $name, "engName" => $engName, "extend" => $extend, "metadata" => $metadata]);
    }
    /**
     * 更新套餐
     * @return  mixed
    */
    public static function updatePackage (int $id, string $module, string $name, string $engName, array $extend, array $metadata) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePackage(["id" => $id, "module" => $module, "name" => $name, "engName" => $engName, "extend" => $extend, "metadata" => $metadata]);
    }
    /**
     * 更新套餐extend
     * @return  mixed
    */
    public static function updatePackageExtend (int $id, array $extend, bool $merge) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePackageExtend(["id" => $id, "extend" => $extend, "merge" => $merge]);
    }
    /**
     * 获取套餐详情
     * @return  mixed
    */
    public static function getPackage (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackage(["id" => $id]);
    }
    /**
     * 套餐复制
     * @return  mixed
    */
    public static function copyPackage (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyPackage(["id" => $id]);
    }
    /**
     * 获取套餐列表
     * @return  mixed
    */
    public static function getPackageList (string $module, string $modules, string $name, string $status, string $statusArr, int $page) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageList(["module" => $module, "modules" => $modules, "name" => $name, "status" => $status, "statusArr" => $statusArr, "page" => $page]);
    }
    /**
     * 获取所有套餐
     * @return  mixed
    */
    public static function getPackageAll (string $module, string $name, string $status, string $statusArr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageAll(["module" => $module, "name" => $name, "status" => $status, "statusArr" => $statusArr]);
    }
    /**
     * 获取所有套餐加强版
     * @return  mixed
    */
    public static function allPackages (array $modules, string $name, array $packageIds, bool $withSubPackage, array $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allPackages(["modules" => $modules, "name" => $name, "packageIds" => $packageIds, "withSubPackage" => $withSubPackage, "status" => $status]);
    }
    /**
     * 通过子套餐ids获取可售卖产品规则
     * @return  array
    */
    public static function getPackageInfoByIds (array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageInfoByIds(["subPackageIds" => $subPackageIds]);
    }
    /**
     * 套餐上架
     * @return  mixed
    */
    public static function upPackage (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upPackage(["id" => $id]);
    }
    /**
     * 套餐下架
     * @return  mixed
    */
    public static function downPackage (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->downPackage(["id" => $id]);
    }
    /**
     * 套餐删除
     * @return  bool
    */
    public static function deletePackage (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deletePackage(["id" => $id]);
    }
    /**
     * 更新套餐上下架时间
     * @return  mixed
    */
    public static function updatePackageTime (int $id, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePackageTime(["id" => $id, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 创建子套餐
     * @return  mixed
    */
    public static function createSubPackage (int $packageId, string $name, int $occupyValue, array $metadata, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSubPackage(["packageId" => $packageId, "name" => $name, "occupyValue" => $occupyValue, "metadata" => $metadata, "extend" => $extend]);
    }
    /**
     * 更新子套餐
     * @return  mixed
    */
    public static function updateSubPackage (int $subPackageId, string $name, int $occupyValue, array $metadata, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSubPackage(["subPackageId" => $subPackageId, "name" => $name, "occupyValue" => $occupyValue, "metadata" => $metadata, "extend" => $extend]);
    }
    /**
     * 子套餐删除
     * @return  bool
    */
    public static function deleteSubPackage (int $subPackageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSubPackage(["subPackageId" => $subPackageId]);
    }
    /**
     * 删除套餐下的所有子套餐
     * @return  bool
    */
    public static function deleteAllSubPackageInPackage (int $packageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAllSubPackageInPackage(["packageId" => $packageId]);
    }
    /**
     * 获取产品id在套餐内出现的次数
     * @return  int
    */
    public static function getProductInPackageCount (int $id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInPackageCount(["id" => $id, "type" => $type]);
    }
    /**
     * 获取套餐可售卖的门店
     * @return  mixed
    */
    public static function getStoreIdsSellPackage (int $packageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsSellPackage(["packageId" => $packageId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}