<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-18 14:06:01
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Channel
 */
class Channel {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Channel";

    /**
     * 新增渠道
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto
    */
    public static function add (string $name, int $channel_num, string $brand = 'himo') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->add(["name" => $name, "channel_num" => $channel_num, "brand" => $brand]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto"
        );
    }
    /**
     * 更新渠道信息
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto
    */
    public static function update (int $id, int $channel_num = 0, string $name = '', string $brand = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "channel_num" => $channel_num, "name" => $name, "brand" => $brand]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto"
        );
    }
    /**
     * 渠道号列表
     * @return  mixed
    */
    public static function list (string $name, int $channelNum, string $brand = 'himo', int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "channelNum" => $channelNum, "brand" => $brand, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 删除渠道
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 获取渠道二维码
     * @return  mixed
    */
    public static function qrcode (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->qrcode(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}