<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-14 16:22:40
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SurplusRefund
 */
class SurplusRefund {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\SurplusRefund";

    /**
     * 创建退款手续费退款
     * @return  mixed
    */
    public static function create (int $orderId, array $refundIds, float $refundMoney, string $people, string $account, string $note, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "refundIds" => $refundIds, "refundMoney" => $refundMoney, "people" => $people, "account" => $account, "note" => $note, "reason" => $reason]);
    }
    /**
     * 手续费剩余退款列表
     * @return  mixed
    */
    public static function list (string $orderNo, int $storeId, array $storeIds, string $status, array $statusList, string $applyTimeStart, string $applyTimeEnd, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderNo" => $orderNo, "storeId" => $storeId, "storeIds" => $storeIds, "status" => $status, "statusList" => $statusList, "applyTimeStart" => $applyTimeStart, "applyTimeEnd" => $applyTimeEnd, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取订单的可退手续费信息
     * @return  array
    */
    public static function getOrderSurplusRefundList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderSurplusRefundList(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\SurplusRefund\Dto\OrderSurplusRefundListDto[]"
        );
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detail (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderNo" => $orderNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}