<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-28 15:38:53
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SupplyChain
 */
class SupplyChain {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\SupplyChain";

    /**
     * 获取供应链员工列表
     */
    public static function getSupplyChainStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyChainStaffs();
    }
    /**
     * 获取子公司数据
     */
    public static function getSubjects () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubjects();
    }
    /**
     * 根据类型获取物料数量
     */
    public static function getStockCount (string $locType): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockCount(["locType" => $locType, ]);
    }
    /**
     * 提交盘点结果(总部)
     */
    public static function submit (int $staffId, int $locType, array $materialInfo, string $applyIn = 'store', int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit(["staffId" => $staffId, "locType" => $locType, "materialInfo" => $materialInfo, "applyIn" => $applyIn, "id" => $id, ]);
    }
    /**
     * 获取盘点数据记录
     */
    public static function getInventories (string $applyIn = 'store', int $page = 1, int $pageSize = 10, string $startTime, string $endTime, int $subjectId, int $storeId, int $staffId, int $locType, string $status, string $checkStatus): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventories(["applyIn" => $applyIn, "page" => $page, "pageSize" => $pageSize, "startTime" => $startTime, "endTime" => $endTime, "subjectId" => $subjectId, "storeId" => $storeId, "staffId" => $staffId, "locType" => $locType, "status" => $status, "checkStatus" => $checkStatus, ]);
    }
    /**
     * 获取盘点记录详情
     */
    public static function getInventory (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventory(["id" => $id, ]);
    }
    /**
     * 保存
     */
    public static function save (int $id, array $info): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->save(["id" => $id, "info" => $info, ]);
    }
    /**
     * 通过
     */
    public static function pass (array $ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["ids" => $ids, ]);
    }
    /**
     * 驳回
     */
    public static function reject (array $ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["ids" => $ids, ]);
    }
    /**
     * 删除盘点记录
     */
    public static function deleteInventory (array $inventoryIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteInventory(["inventoryIds" => $inventoryIds, ]);
    }
    /**
     * 盘点导出
     */
    public static function exportInventory (string $applyIn = 'store', string $startTime, string $endTime, int $storeId, int $staffId, int $locType, string $status, string $checkStatus): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportInventory(["applyIn" => $applyIn, "startTime" => $startTime, "endTime" => $endTime, "storeId" => $storeId, "staffId" => $staffId, "locType" => $locType, "status" => $status, "checkStatus" => $checkStatus, ]);
    }
    /**
     * 获取库存数据
     */
    public static function getStocks (int $page = 1, int $pageSize = 10, int $stockTaking = 1, int $storeId, int $locType, int $safeQuantity): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStocks(["page" => $page, "pageSize" => $pageSize, "stockTaking" => $stockTaking, "storeId" => $storeId, "locType" => $locType, "safeQuantity" => $safeQuantity, ]);
    }
    /**
     * 获取库存
     */
    public static function getStock (int $storeId, int $skuId, int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStock(["storeId" => $storeId, "skuId" => $skuId, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 库存导出
     */
    public static function exportStock (string $storeId, int $locType, int $safeQuantity): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportStock(["storeId" => $storeId, "locType" => $locType, "safeQuantity" => $safeQuantity, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}