<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-28 15:38:53
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Order";

    /**
     * 订单列表查询
     */
    public static function list (string $orderNo, string $reserveTimeStart, string $reserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $status, string $statusList, string $module = 'himo', string $userName, string $userPhone, int $userId, bool $allStore, int $page, int $pageSize, string $sortField, bool $sortDesc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderNo" => $orderNo, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "status" => $status, "statusList" => $statusList, "module" => $module, "userName" => $userName, "userPhone" => $userPhone, "userId" => $userId, "allStore" => $allStore, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, ]);
    }
    /**
     * 全局订单列表查询
     */
    public static function globalSearch (string $orderNo, string $userName, string $userPhone, int $page, int $pageSize, bool $withDel = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->globalSearch(["orderNo" => $orderNo, "userName" => $userName, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, "withDel" => $withDel, ]);
    }
    /**
     * 获取全局订单详情
     */
    public static function globalOrderDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->globalOrderDetail(["id" => $id, ]);
    }
    /**
     * 获取全局订单-无纸化详情
     */
    public static function globalOrderPaperlessDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->globalOrderPaperlessDetail(["id" => $id, ]);
    }
    /**
     * 获取订单关联的售后单
     */
    public static function afterSaleOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterSaleOrder(["id" => $id, ]);
    }
    /**
     * 获取订单详情
     */
    public static function detail (int $id, string $orderNo, bool $withDelete, bool $withTurnover, bool $withRefund, bool $checkedStudentMember = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withTurnover" => $withTurnover, "withRefund" => $withRefund, "checkedStudentMember" => $checkedStudentMember, ]);
    }
    /**
     * 修改拍摄内容关闭的产品、升级服务在拍摄内容列表
     */
    public static function editOrderProductList (int $orderId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editOrderProductList(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\EditOrderProductListDto[]"
        );
    }
    /**
     * 获取订单流水
     */
    public static function getOrderTurnovers (string $orderNo, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderTurnovers(["orderNo" => $orderNo, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 财务修改支付方式
     */
    public static function changePayType (int $id, string $payType, string $orderType, string $paymentNo, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payType" => $payType, "orderType" => $orderType, "paymentNo" => $paymentNo, "orderId" => $orderId, ]);
    }
    /**
     * 云端订单详情
     */
    public static function cloudOrderDetail (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloudOrderDetail(["order_no" => $order_no, ]);
    }
    /**
     * 修改订单备注
     */
    public static function changeNote (int $id, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeNote(["id" => $id, "note" => $note, ]);
    }
    /**
     * 创建订单
     */
    public static function create (int $userId, string $userName, string $userPhone, string $userSex, string $userBirthday, float $money, float $realMoney, array $productInfo, int $reachedPeopleNum, string $interiorCouponCode, float $interiorCouponDeductionMoney, int $couponId, float $couponDeductionMoney, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, string $discountType, string $discountNote, int $specialDiscountStaffId, string $reserveTime, array $groupOrderItemIds, string $type, string $note, string $module = 'himo', array $retailProducts, array $packageDiscountIds, float $packageDiscountMoney, float $weekdayDiscountMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["userId" => $userId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "reachedPeopleNum" => $reachedPeopleNum, "interiorCouponCode" => $interiorCouponCode, "interiorCouponDeductionMoney" => $interiorCouponDeductionMoney, "couponId" => $couponId, "couponDeductionMoney" => $couponDeductionMoney, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "discountType" => $discountType, "discountNote" => $discountNote, "specialDiscountStaffId" => $specialDiscountStaffId, "reserveTime" => $reserveTime, "groupOrderItemIds" => $groupOrderItemIds, "type" => $type, "note" => $note, "module" => $module, "retailProducts" => $retailProducts, "packageDiscountIds" => $packageDiscountIds, "packageDiscountMoney" => $packageDiscountMoney, "weekdayDiscountMoney" => $weekdayDiscountMoney, ]);
    }
    /**
     * 设置拍摄订单签到
     */
    public static function userReached (int $orderId, int $reachedPeopleNum, bool $needMoney, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "needMoney" => $needMoney, "money" => $money, ]);
    }
    /**
     * 修改拍摄订单签到
     */
    public static function modifyUserReached (int $orderId, int $orderDiffId, int $reachedPeopleNum, bool $needMoney, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyUserReached(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "reachedPeopleNum" => $reachedPeopleNum, "needMoney" => $needMoney, "money" => $money, ]);
    }
    /**
     * 设置签到完成支付
     */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType, string $paymentNo, int $operateId, bool $fromPaymentGateway) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserReachedPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "payType" => $payType, "paymentNo" => $paymentNo, "operateId" => $operateId, "fromPaymentGateway" => $fromPaymentGateway, ]);
    }
    /**
     * 拍摄签到详情
     */
    public static function getUserReachedDetail (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserReachedDetail(["orderId" => $orderId, ]);
    }
    /**
     * 取消绑定用户
     */
    public static function unbindUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindUser(["id" => $id, ]);
    }
    /**
     * 修改订单所属用户
     */
    public static function updateUser (string $order_num, string $phone, string $bindReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUser(["order_num" => $order_num, "phone" => $phone, "bindReason" => $bindReason, ]);
    }
    /**
     * 取消订单
     */
    public static function cancel (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "reason" => $reason, ]);
    }
    /**
     * 完成支付
     */
    public static function paid (int $id, int $orderDiffId, string $payType, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 关闭订单
     */
    public static function close (int $id, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, "note" => $note, ]);
    }
    /**
     * 把订单设置为退款关闭【只更改主订单状态】
     */
    public static function setOrderClosedByRefund (string $order_no, string $closed_at) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderClosedByRefund(["order_no" => $order_no, "closed_at" => $closed_at, ]);
    }
    /**
     * 开始订单
     */
    public static function start (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->start(["id" => $id, ]);
    }
    /**
     * 完成订单（拍摄完成）
     */
    public static function finish (int $id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finish(["id" => $id, "workloads" => $workloads, ]);
    }
    /**
     * 恢复到等待拍摄
     */
    public static function recoverWaitShooting (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverWaitShooting(["id" => $id, ]);
    }
    /**
     * 拍摄完成的订单恢复到等待拍摄
     */
    public static function recoverFinishedToWaitShooting (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverFinishedToWaitShooting(["id" => $id, ]);
    }
    /**
     * 修改预约时间
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeReserveTime(["id" => $id, "reserve_time" => $reserve_time, ]);
    }
    /**
     * 修改用户数据
     */
    public static function changeUserData (int $id, string $user_name, string $user_sex) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "user_name" => $user_name, "user_sex" => $user_sex, ]);
    }
    /**
     * 转门店
     */
    public static function changeStore (int $id, int $storeId, string $reserveTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStore(["id" => $id, "storeId" => $storeId, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 转门店前检查
     */
    public static function checkTransferStore (int $id, int $storeId, string $reserveTime): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkTransferStore(["id" => $id, "storeId" => $storeId, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 删除订单
     */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, ]);
    }
    /**
     * 用户可用优惠券列表
     */
    public static function getCanUseCouponList (array $product_group_ids, array $product_ids, array $service_product_ids, int $user_id, string $apply_in = 'himo', int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanUseCouponList(["product_group_ids" => $product_group_ids, "product_ids" => $product_ids, "service_product_ids" => $service_product_ids, "user_id" => $user_id, "apply_in" => $apply_in, "order_id" => $order_id, ]);
    }
    /**
     * 用户可用产品卡列表
     */
    public static function getCanUseProductCardList (array $product_group_ids, array $product_ids, array $service_product_ids, int $user_id, string $apply_in = 'himo', int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanUseProductCardList(["product_group_ids" => $product_group_ids, "product_ids" => $product_ids, "service_product_ids" => $service_product_ids, "user_id" => $user_id, "apply_in" => $apply_in, "order_id" => $order_id, ]);
    }
    /**
     * 获取订单可用优惠券
     */
    public static function getOrderJxjyCoupons (int $order_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderJxjyCoupons(["order_id" => $order_id, ]);
    }
    /**
     * 获取用户加修加印券
     */
    public static function jxjyCoupon (int $user_id, array $product_group_ids, array $product_ids, string $apply_in = 'himo', int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->jxjyCoupon(["user_id" => $user_id, "product_group_ids" => $product_group_ids, "product_ids" => $product_ids, "apply_in" => $apply_in, "order_id" => $order_id, ]);
    }
    /**
     * 获取优惠券详情
     */
    public static function getCouponInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponInfo(["id" => $id, ]);
    }
    /**
     * 获取产品券详情
     */
    public static function getProductCardInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardInfo(["id" => $id, ]);
    }
    /**
     * 计算优惠券可抵扣信息
     */
    public static function calCouponDeductionInfo (array $detail, int $coupon_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calCouponDeductionInfo(["detail" => $detail, "coupon_id" => $coupon_id, ]);
    }
    /**
     * 计算产品卡可抵扣信息
     */
    public static function calProductDeductionInfo (array $detail, int $product_card_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductDeductionInfo(["detail" => $detail, "product_card_id" => $product_card_id, ]);
    }
    /**
     * 订单开单折扣码抵扣
     */
    public static function calInteriorCouponDeductionInfo (string $interior_coupon_code, bool $verify_usability) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calInteriorCouponDeductionInfo(["interior_coupon_code" => $interior_coupon_code, "verify_usability" => $verify_usability, ]);
    }
    /**
     * 管理端查询订单操作记录
     */
    public static function operateLog (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operateLog(["order_id" => $order_id, ]);
    }
    /**
     * 获取当日售卖产品总数
     */
    public static function reserveProductCount (string $reserveTimeStart, string $reserveTimeEnd, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reserveProductCount(["reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取加密订单号
     */
    public static function getEncryptOrderNum (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEncryptOrderNum(["order_num" => $order_num, ]);
    }
    /**
     * 获取短链接
     */
    public static function getShortUrl (string $order_num, string $url, string $pay_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShortUrl(["order_num" => $order_num, "url" => $url, "pay_type" => $pay_type, ]);
    }
    /**
     * 发送付款链接
     */
    public static function sendPayLink (int $orderId, string $url, string $orderType, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPayLink(["orderId" => $orderId, "url" => $url, "orderType" => $orderType, "phone" => $phone, ]);
    }
    /**
     * 获取订单预选服装
     */
    public static function orderCloth (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderCloth(["order_id" => $order_id, ]);
    }
    /**
     * 获取订单预选服装
     */
    public static function orderClothsByOrderIds (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderClothsByOrderIds(["orderIds" => $orderIds, ]);
    }
    /**
     * 门店最终选衣
     */
    public static function updateOrderCloth (int $order_id, int $item_id, array $final_cloth = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrderCloth(["order_id" => $order_id, "item_id" => $item_id, "final_cloth" => $final_cloth, ]);
    }
    /**
     * 门店换产品处理选衣
     */
    public static function itemOrderCloth (int $order_id, int $item_id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemOrderCloth(["order_id" => $order_id, "item_id" => $item_id, ]);
    }
    /**
     * 查询鸳鸯照码的发送情况
     */
    public static function yuanYangCode (int $limit = 500, string $order_no, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->yuanYangCode(["limit" => $limit, "order_no" => $order_no, "status" => $status, ]);
    }
    /**
     * 退款订单备注
     */
    public static function partRefundNote (string $order_no, float $money, int $type = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->partRefundNote(["order_no" => $order_no, "money" => $money, "type" => $type, ]);
    }
    /**
     * 修改使用礼品卡金额
     */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useGiftCardMoney(["id" => $id, "giftCardPayMoney" => $giftCardPayMoney, ]);
    }
    /**
     * 修改使用商场卡金额
     */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useMarketCardMoney(["id" => $id, "marketCardMoney" => $marketCardMoney, ]);
    }
    /**
     * 使用礼品卡支付确认的推送
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendGiftCardPayDsConfirmPush(["id" => $id, "giftCardMoney" => $giftCardMoney, ]);
    }
    /**
     * 发送礼品卡使用通知
     */
    public static function sendGiftCardNotify (int $id, float $giftCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendGiftCardNotify(["id" => $id, "giftCardMoney" => $giftCardMoney, ]);
    }
    /**
     * 查账助手-根据订单类型获取
     */
    public static function listByPay (string $type, string $payType, string $paidAtStart, string $paidAtEnd, string $pageSize, string $page) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listByPay(["type" => $type, "payType" => $payType, "paidAtStart" => $paidAtStart, "paidAtEnd" => $paidAtEnd, "pageSize" => $pageSize, "page" => $page, ]);
    }
    /**
     * 获取门店产品树
     */
    public static function getStoreProduct (string $status = 'on', int $show_level = 2, bool $c_hidden, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProduct(["status" => $status, "show_level" => $show_level, "c_hidden" => $c_hidden, "store_id" => $store_id, ]);
    }
    /**
     * 获取重拍订单的基础信息
     */
    public static function getBaseRetakeInfo (int $orderId, int $retakeOrderId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfo(["orderId" => $orderId, "retakeOrderId" => $retakeOrderId, "status" => $status, ]);
    }
    /**
     * 获取订单信息及流水
     */
    public static function getInfoAndTurnovers (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoAndTurnovers(["orderNo" => $orderNo, ]);
    }
    /**
     * 修改二销主推
     */
    public static function editDSInputStaff (int $orderId, int $turnoverId, array $inputStaff) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editDSInputStaff(["orderId" => $orderId, "turnoverId" => $turnoverId, "inputStaff" => $inputStaff, ]);
    }
    /**
     * 获取二销主推人
     */
    public static function getDSInputStaff (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDSInputStaff(["orderNo" => $orderNo, ]);
    }
    /**
     * 获取修改预约时间订单优惠发生变化信息
     */
    public static function getOrderDiscountChangeInfo (int $orderId, string $reserveTime): \Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetOrderDiscountChangeInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderDiscountChangeInfo(["orderId" => $orderId, "reserveTime" => $reserveTime, ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetOrderDiscountChangeInfoDTO"
        );
    }
    /**
     * 是否需要手续费
     */
    public static function isNeedCharge (string $appointAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isNeedCharge(["appointAt" => $appointAt, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}