<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-28 11:04:46
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Staff";

    /**
     * 获取员工列表
     */
    public static function list (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["store_id" => $store_id, ]);
    }
    /**
     * 根据分类获取门店成员列表
     */
    public static function storeStaff (int $store_id, string $staff_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeStaff(["store_id" => $store_id, "staff_type" => $staff_type, ]);
    }
    /**
     * 兼岗确认添加对应门店权限
     */
    public static function staffPluralismConfirm (int $pluralism_store_id, int $staff_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismConfirm(["pluralism_store_id" => $pluralism_store_id, "staff_id" => $staff_id, ]);
    }
    /**
     * 兼岗结束删除对应门店权限
     */
    public static function staffPluralismStop (int $pluralism_store_id, int $staff_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismStop(["pluralism_store_id" => $pluralism_store_id, "staff_id" => $staff_id, ]);
    }
    /**
     * 伙伴更新
     */
    public static function staffChangeDepartment (array $new_staff, array $old_staff): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffChangeDepartment(["new_staff" => $new_staff, "old_staff" => $old_staff, ]);
    }
    /**
     * 获取技术专家列表
     */
    public static function getTechnologistList (string $name, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTechnologistList(["name" => $name, "type" => $type, ]);
    }
    /**
     * 通过姓名或花名获取伙伴
     */
    public static function getStaffByRealOrNickName (int $technologistId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByRealOrNickName(["technologistId" => $technologistId, "name" => $name, ]);
    }
    /**
     * 技术专家关联督导
     */
    public static function assignSupervisor (int $technologist_id, array $supervisor_ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignSupervisor(["technologist_id" => $technologist_id, "supervisor_ids" => $supervisor_ids, ]);
    }
    /**
     * 通过技术专家获取督导
     */
    public static function getSupervisorByTechnologist (array $technologist_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupervisorByTechnologist(["technologist_ids" => $technologist_ids, ]);
    }
    /**
     * 获取专家关联信息
     */
    public static function getStaffRelation (array $technologist_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRelation(["technologist_ids" => $technologist_ids, ]);
    }
    /**
     * 根据分类获取门店成员列表
     */
    public static function getStaffByType (array $storeIds, string $staffType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByType(["storeIds" => $storeIds, "staffType" => $staffType, ]);
    }
    /**
     * 查询员工id
     */
    public static function queryStaff (string $nameOrNickname, string $phone): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryStaff(["nameOrNickname" => $nameOrNickname, "phone" => $phone, ]);
    }
    /**
     * 根据门店获取岗位
     */
    public static function getPositions (array $storeIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPositions(["storeIds" => $storeIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}