<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-21 19:24:44
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CheckPool
 */
class CheckPool {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\CheckPool";

    /**
     * 抽片
     */
    public static function extract (string $poolType, int $newStaffCount, int $formalStaffCount, array $productArr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->extract(["poolType" => $poolType, "newStaffCount" => $newStaffCount, "formalStaffCount" => $formalStaffCount, "productArr" => $productArr, ]);
    }
    /**
     * 获取抽片进度
     */
    public static function getProgress (string $poolType): float {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProgress(["poolType" => $poolType, ]);
    }
    /**
     * 通过品牌获取所有产品
     */
    public static function getAllProductByBrand (string $brand = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductByBrand(["brand" => $brand, ]);
    }
    /**
     * 今日已评单量
     */
    public static function getTodayEvaluateCount (string $poolType): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayEvaluateCount(["poolType" => $poolType, ]);
    }
    /**
     * 获取抽片列表
     */
    public static function getExtractList (string $poolType, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExtractList(["poolType" => $poolType, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 不处理此项
     */
    public static function notDealWithTheItem (string $poolType, string $itemId, int $staffId, bool $todayNotExtract = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->notDealWithTheItem(["poolType" => $poolType, "itemId" => $itemId, "staffId" => $staffId, "todayNotExtract" => $todayNotExtract, ]);
    }
    /**
     * 换一单
     */
    public static function changeItem (string $poolType, string $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItem(["poolType" => $poolType, "itemId" => $itemId, ]);
    }
    /**
     * 预评分
     */
    public static function preCommitScore (string $poolType, string $itemId, array $score) {
        return RpcClass::getClass(self::$serviceName, self::$className)->preCommitScore(["poolType" => $poolType, "itemId" => $itemId, "score" => $score, ]);
    }
    /**
     * 获取预评分列表
     */
    public static function getPreScoreList (string $poolType, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreScoreList(["poolType" => $poolType, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 最终确认
     */
    public static function confirm (string $poolType, array $batchScore) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirm(["poolType" => $poolType, "batchScore" => $batchScore, ]);
    }
    /**
     * 预检查是否可以更新配置
     */
    public static function preCheckUpdateConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->preCheckUpdateConfig(["poolType" => $poolType, ]);
    }
    /**
     * 锁配置
     */
    public static function lockUpdateConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lockUpdateConfig(["poolType" => $poolType, ]);
    }
    /**
     * 解锁配置
     */
    public static function unlockUpdateConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unlockUpdateConfig(["poolType" => $poolType, ]);
    }
    /**
     * 获取评分配置
     */
    public static function getScoreConfig (string $poolType, bool $withDel = false, bool $filterZero = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreConfig(["poolType" => $poolType, "withDel" => $withDel, "filterZero" => $filterZero, ]);
    }
    /**
     * 评分配置调整
     */
    public static function updateScoreConfig (string $poolType, array $delConfig = [], array $newConfig = [], array $updateConfig = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateScoreConfig(["poolType" => $poolType, "delConfig" => $delConfig, "newConfig" => $newConfig, "updateConfig" => $updateConfig, ]);
    }
    /**
     * 查询评分历史记录
     */
    public static function queryRecordHistory (string $poolType, string $startTime, string $endTime, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryRecordHistory(["poolType" => $poolType, "startTime" => $startTime, "endTime" => $endTime, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 查询质量报告
     */
    public static function queryQualityReport (string $poolType, string $startTime, string $endTime, array $storeIds, array $productIds, array $problemTagsIds, array $supervisorArr, array $staffIds, array $score, array $totalScoreRange, string $order_num, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryQualityReport(["poolType" => $poolType, "startTime" => $startTime, "endTime" => $endTime, "storeIds" => $storeIds, "productIds" => $productIds, "problemTagsIds" => $problemTagsIds, "supervisorArr" => $supervisorArr, "staffIds" => $staffIds, "score" => $score, "totalScoreRange" => $totalScoreRange, "order_num" => $order_num, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 查询聚合数据
     */
    public static function queryHistoryAggregate (string $poolType, string $startTime, string $endTime, array $storeIds, array $productIds, array $problemTagsIds, array $supervisorArr, array $staffIds, array $score, array $totalScoreRange, string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryHistoryAggregate(["poolType" => $poolType, "startTime" => $startTime, "endTime" => $endTime, "storeIds" => $storeIds, "productIds" => $productIds, "problemTagsIds" => $problemTagsIds, "supervisorArr" => $supervisorArr, "staffIds" => $staffIds, "score" => $score, "totalScoreRange" => $totalScoreRange, "order_num" => $order_num, ]);
    }
    /**
     * 通过伙伴获取有权限的门店信息
     */
    public static function getStoreIdsByStaff (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsByStaff(["staffIds" => $staffIds, ]);
    }
    /**
     * 获取伙伴(根据入职时间)
     */
    public static function getStaff (string $staffEntryType = '', array $storeIds = [], string $nameOrNickname = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaff(["staffEntryType" => $staffEntryType, "storeIds" => $storeIds, "nameOrNickname" => $nameOrNickname, ]);
    }
    /**
     * 获取流水信息
     */
    public static function getStreamInfo (string $poolType, int $cloudStreamId, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(["poolType" => $poolType, "cloudStreamId" => $cloudStreamId, "startTime" => $startTime, "endTime" => $endTime, ]);
    }
    /**
     * 定时任务提交最终评分
     */
    public static function cronSubmitFinalCommit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSubmitFinalCommit();
    }
    /**
     * 删除评分
     */
    public static function delScore (string $poolType, int $cloudStreamId, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delScore(["poolType" => $poolType, "cloudStreamId" => $cloudStreamId, "startTime" => $startTime, "endTime" => $endTime, ]);
    }
    /**
     * 获取摄影化妆问题标签
     */
    public static function getPhotoProblemTagSets (string $about = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoProblemTagSets(["about" => $about, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}