<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-31 15:57:31
 */
namespace Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd;

class AnnouncementCreate {
    /**
     * @var  string
     * 公告标题
     * validation: string|max:50|required
     */
    public string $title;
    /**
     * @var  null|string
     * 发布时间
     * validation: date_format:Y-m-d H:i:s|after:now
     */
    public ?string $publishAt = null;
    /**
     * @var  int
     * 板块id
     * validation: integer|announcementCategory
     */
    public int $categoryId;
    /**
     * @var  null|string
     * 弹窗时间
     * validation: date_format:Y-m-d H:i:s|after:now
     */
    public ?string $popTime = null;
    /**
     * @var  int
     * 阅读时长/3-15s
     * validation: integer|between:3,15|required
     */
    public int $timeLimit;
    /**
     * @var  array
     * 公告品牌列表
     * validation: moduleList
     */
    public array $modules;
    /**
     * @var  array
     * 可收到消息的门店列表
     * validation: array|announcementStores
     */
    public array $stores = [];
    /**
     * @var  array
     * 可收到消息的角色列表
     * validation: array|announcementRoles
     */
    public array $roles = [];
    /**
     * @var  array
     * 附件列表
     * validation: attachmentsCount:10
     */
    public array $attachments = [];
    /**
     * @var  string
     * 配置名, 用于获取特定token等, xiaobai
     * validation: 
     */
    public string $config;
    /**
     * @var  bool
     * 
     * validation: 
     */
    public bool $top = false;
    /**
     * @var  string
     * 文本
     * validation: 
     */
    public string $content;
    /**
     * @var  string
     * 跳转链接
     * validation: 
     */
    public string $url = "";

    public function __construct (string $title, int $categoryId, int $timeLimit, array $modules, string $config, string $content) {
        $this->title = $title;
        $this->categoryId = $categoryId;
        $this->timeLimit = $timeLimit;
        $this->modules = $modules;
        $this->config = $config;
        $this->content = $content;
    }

    public static function create(string $title, int $categoryId, int $timeLimit, array $modules, string $config, string $content): self {
        return new self($title, $categoryId, $timeLimit, $modules, $config, $content);
    }

    public function setTitle(string $title): self {
        $this->title = $title;

        return $this;
    }

    public function setPublishAt(?string $publishAt): self {
        $this->publishAt = $publishAt;

        return $this;
    }

    public function setCategoryId(int $categoryId): self {
        $this->categoryId = $categoryId;

        return $this;
    }

    public function setPopTime(?string $popTime): self {
        $this->popTime = $popTime;

        return $this;
    }

    public function setTimeLimit(int $timeLimit): self {
        $this->timeLimit = $timeLimit;

        return $this;
    }

    public function setModules(array $modules): self {
        $this->modules = $modules;

        return $this;
    }

    public function setStores(array $stores): self {
        $this->stores = $stores;

        return $this;
    }

    public function setRoles(array $roles): self {
        $this->roles = $roles;

        return $this;
    }

    public function setAttachments(array $attachments): self {
        $this->attachments = $attachments;

        return $this;
    }

    public function setConfig(string $config): self {
        $this->config = $config;

        return $this;
    }

    public function setTop(bool $top): self {
        $this->top = $top;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setUrl(string $url): self {
        $this->url = $url;

        return $this;
    }
}