<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-31 19:06:19
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Auth
 */
class Auth {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Auth";

    /**
     * 获取管理员信息
     *
     */
    public static function staffInfo (string $staffName, string $type = 'core'): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffInfo(["staffName" => $staffName, "type" => $type, ]);
    }
    /**
     * 获取当前门店
     *
     */
    public static function currentStore (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->currentStore();
    }
    /**
     * 设置当前门店
     *
     */
    public static function selectStore (int $store_id): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->selectStore(["store_id" => $store_id, ]);
    }
    /**
     * 获取加盟商信息
     *
     */
    public static function affiliateInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->affiliateInfo();
    }
    /**
     * 获取kids系统权限列表
     *
     */
    public static function getKidsAuthList (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getKidsAuthList();
    }
    /**
     * bmsApp 持久化登陆
     *
     */
    public static function login (string $code): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->login(["code" => $code, ]);
    }
    /**
     * bmsApp 退出
     *
     */
    public static function logOut (string $deviceUniqueNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logOut(["deviceUniqueNo" => $deviceUniqueNo, ]);
    }
    /**
     * 获取 App 持久化 Code
     *
     */
    public static function getLoginCode (string $deviceUniqueNo, array $extend): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLoginCode(["deviceUniqueNo" => $deviceUniqueNo, "extend" => $extend, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}