<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-05 16:58:33
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderRefund
 */
class OrderRefund {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\OrderRefund";

    /**
     * 退款列表
     *
     */
    public static function list (string $order_no, string $status, string $brand, string $status_list, int $store_id, array $store_ids, string $pay_type, string $apply_time_start, string $apply_time_end, string $process_time_start, string $process_time_end, string $complete_time_start, string $complete_time_end, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["order_no" => $order_no, "status" => $status, "brand" => $brand, "status_list" => $status_list, "store_id" => $store_id, "store_ids" => $store_ids, "pay_type" => $pay_type, "apply_time_start" => $apply_time_start, "apply_time_end" => $apply_time_end, "process_time_start" => $process_time_start, "process_time_end" => $process_time_end, "complete_time_start" => $complete_time_start, "complete_time_end" => $complete_time_end, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 根据订单的拍摄产品获取可退信息
     *
     */
    public static function calcRefundInfoByOrderItems (int $orderId, string $refundType, array $refundInfo, bool $withDelete) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calcRefundInfoByOrderItems(["orderId" => $orderId, "refundType" => $refundType, "refundInfo" => $refundInfo, "withDelete" => $withDelete, ]);
    }
    /**
     * 退款申请v2
     *
     */
    public static function createV2 (int $orderId, string $refundType, int $scale, string $people, string $account, string $reason, array $reasonIds, string $note, array $refundInfo, bool $withDelete) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createV2(["orderId" => $orderId, "refundType" => $refundType, "scale" => $scale, "people" => $people, "account" => $account, "reason" => $reason, "reasonIds" => $reasonIds, "note" => $note, "refundInfo" => $refundInfo, "withDelete" => $withDelete, ]);
    }
    /**
     * 退款处理V2
     *
     */
    public static function confirmV2 (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmV2(["id" => $id, ]);
    }
    /**
     * 退款申请并退款v2
     *
     */
    public static function createAndConfirmV2 (int $orderId, string $refundType, string $refundMoneyType = 'normal', float $refundMoney, int $scale, string $people, string $account, string $reason, array $reasonIds, string $note, array $refundInfo, bool $withDelete) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAndConfirmV2(["orderId" => $orderId, "refundType" => $refundType, "refundMoneyType" => $refundMoneyType, "refundMoney" => $refundMoney, "scale" => $scale, "people" => $people, "account" => $account, "reason" => $reason, "reasonIds" => $reasonIds, "note" => $note, "refundInfo" => $refundInfo, "withDelete" => $withDelete, ]);
    }
    /**
     * 创建特殊部分退款申请并处理
     *
     */
    public static function createSpecialRefundAndConfirm (int $orderId, string $refundType, string $refundMoneyType = 'normal', float $refundMoney, string $people, string $account, string $reason, array $reasonIds, string $note, array $refundInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSpecialRefundAndConfirm(["orderId" => $orderId, "refundType" => $refundType, "refundMoneyType" => $refundMoneyType, "refundMoney" => $refundMoney, "people" => $people, "account" => $account, "reason" => $reason, "reasonIds" => $reasonIds, "note" => $note, "refundInfo" => $refundInfo, ]);
    }
    /**
     * 对待确认的错误退款进行修正
     *
     */
    public static function fixDubiousRefundResult (int $id, float $auto_real_money): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixDubiousRefundResult(["id" => $id, "auto_real_money" => $auto_real_money, ]);
    }
    /**
     * 修改信息
     *
     */
    public static function fixRefundAccount (int $id, string $people, string $account) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixRefundAccount(["id" => $id, "people" => $people, "account" => $account, ]);
    }
    /**
     * 退款详情
     *
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 存疑自动退款-改为已退
     *
     */
    public static function doubtSuccess (int $refundId, int $refundMoneyDetailId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doubtSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, ]);
    }
    /**
     * 存疑自动退款-改为未退
     *
     */
    public static function doubtError (int $refundId, int $refundMoneyDetailId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doubtError(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, ]);
    }
    /**
     * 存疑自动退款未退订单-改为已退
     *
     */
    public static function doubtErrorToSuccess (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doubtErrorToSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 手动退款订单-标记为已处理
     *
     */
    public static function manualSuccess (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 拒绝退款
     *
     */
    public static function refuse (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuse(["id" => $id, "reason" => $reason, ]);
    }
    /**
     * 退款理由
     *
     */
    public static function reason (string $category, int $parent_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reason(["category" => $category, "parent_id" => $parent_id, ]);
    }
    /**
     * 手动退款再次确认
     *
     */
    public static function confirmHandRefund (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmHandRefund(["id" => $id, ]);
    }
    /**
     * 获取订单退款信息
     *
     */
    public static function getOrderRefundInfo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderRefundInfo(["order_no" => $order_no, ]);
    }
    /**
     * 接收预约端退款消息
     *
     */
    public static function afterRefundForPlatform (int $refundId, float $oldRefundMoney): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterRefundForPlatform(["refundId" => $refundId, "oldRefundMoney" => $oldRefundMoney, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}