<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-09 12:47:52
 */
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RetailInventory
 */
class RetailInventory {
    private static string $serviceName = "HimoProduct";

    private static string $className = "SupplyChain\\RetailInventory";

    /**
     * 获取盘点数据记录
     *
     */
    public static function getInventories (string $startTime, string $endTime, array $storeIds, int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventories(["startTime" => $startTime, "endTime" => $endTime, "storeIds" => $storeIds, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取盘点记录详情
     *
     */
    public static function getInventory (int $id, int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventory(["id" => $id, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 新增导出任务
     *
     */
    public static function newTask (string $template_id, array $params): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id, "params" => $params, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}