<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-06 12:00:04
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Campaign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Campaign
 */
class Campaign {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Campaign\\Campaign";

    /**
     * 初始化活动
     *
     */
    public static function initCampaign (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->initCampaign();
    }
    /**
     * 保存预览模版
     *
     */
    public static function previewCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCMD $campaignPreviewCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->previewCampaignTemplate($campaignPreviewCMD);
    }
    /**
     * 保存模版
     *
     */
    public static function saveCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCMD $campaignSaveCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCampaignTemplate($campaignSaveCMD);
    }
    /**
     * 发布模版
     *
     */
    public static function publishCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPublishCMD $campaignPublishCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->publishCampaignTemplate($campaignPublishCMD);
    }
    /**
     * 获取活动模版详情
     *
     */
    public static function getCampaignDetail (int $campaignId, string $versionStatus): \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCampaignDetail(["campaignId" => $campaignId, "versionStatus" => $versionStatus, ]),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDTO"
        );
    }
    /**
     * 承接页活动列表
     *
     */
    public static function getCampaignList (?\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd = null): \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCampaignList($campaignListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO"
        );
    }
    /**
     * 承接页活动上下线
     *
     */
    public static function updateCampaignStatus (int $campaignId, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCampaignStatus(["campaignId" => $campaignId, "status" => $status, ]);
    }
    /**
     * 承接页活动删除
     *
     */
    public static function campaignDelete (int $campaignId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->campaignDelete(["campaignId" => $campaignId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}