<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-10 11:44:57
 */
namespace Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd;

class ActivitiesRecordAddCmd {
    /**
     * @var  null|int
     * 活动备案id,编辑时传递
     * validation: 
     */
    public ?int $activityRecordId = null;
    /**
     * @var  string
     * 活动业务域
     * validation: enum:activitiesRecordSource
     */
    public string $source;
    /**
     * @var  string
     * 活动类型
     * validation: enum:activitiesRecordType
     */
    public string $type;
    /**
     * @var  null|string
     * 商场名称
     * validation: max:50|EmptyString
     */
    public ?string $marketName = "";
    /**
     * @var  string
     * 活动名称
     * validation: max:50|EmptyString
     */
    public string $name;
    /**
     * @var  string
     * 活动平台
     * validation: enum:activitiesRecordPlatformType
     */
    public string $platformType;
    /**
     * @var  string
     * 活动平台地址
     * validation: max:50
     */
    public string $platformAddress;
    /**
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordTagsCmd
     * 活动目标
     * validation: 
     */
    public \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordTagsCmd $tags;
    /**
     * @var  float
     * 活动预算
     * validation: ActivityRecordBudget
     */
    public float $budget;
    /**
     * @var  string
     * 活动开始时间
     * validation: date_format:Y-m-d
     */
    public string $startAt;
    /**
     * @var  string
     * 活动结束时间
     * validation: date_format:Y-m-d
     */
    public string $endAt;
    /**
     * @var  int[]
     * 活动负责人
     * validation: 
     */
    public array $leaderStaffIds;
    /**
     * @var  null|string
     * 联系方式
     * validation: sometimes|check_phone
     */
    public ?string $leaderPhone = "";
    /**
     * @var  array
     * 券码申请人
     * validation: 
     */
    public array $recordStaffs;
    /**
     * @var  array
     * 申请券码类型
     * validation: preferentialTypeList
     */
    public array $preferentialTypeList;
    /**
     * @var  null|float
     * 折扣力度
     * validation: min:0
     */
    public ?float $discount = null;
    /**
     * @var  string
     * 活动内容
     * validation: max:500|EmptyString
     */
    public string $notes;
    /**
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordFileCmd[]
     * 活动方案
     * validation: 
     */
    public array $files;

    public function __construct (int $createStaffId, string $source, string $type, string $name, string $platformType, string $platformAddress, \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordTagsCmd $tags, float $budget, string $startAt, string $endAt, array $leaderStaffIds, array $recordStaffs, array $preferentialTypeList, string $notes, array $files) {
        $this->createStaffId = $createStaffId;
        $this->source = $source;
        $this->type = $type;
        $this->name = $name;
        $this->platformType = $platformType;
        $this->platformAddress = $platformAddress;
        $this->tags = $tags;
        $this->budget = $budget;
        $this->startAt = $startAt;
        $this->endAt = $endAt;
        $this->leaderStaffIds = $leaderStaffIds;
        $this->recordStaffs = $recordStaffs;
        $this->preferentialTypeList = $preferentialTypeList;
        $this->notes = $notes;
        $this->files = $files;
    }

    public static function create(int $createStaffId, string $source, string $type, string $name, string $platformType, string $platformAddress, \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordTagsCmd $tags, float $budget, string $startAt, string $endAt, array $leaderStaffIds, array $recordStaffs, array $preferentialTypeList, string $notes, array $files): self {
        return new self($createStaffId, $source, $type, $name, $platformType, $platformAddress, $tags, $budget, $startAt, $endAt, $leaderStaffIds, $recordStaffs, $preferentialTypeList, $notes, $files);
    }

    public function setActivityRecordId(?int $activityRecordId): self {
        $this->activityRecordId = $activityRecordId;

        return $this;
    }

    public function setSource(string $source): self {
        $this->source = $source;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setMarketName(?string $marketName): self {
        $this->marketName = $marketName;

        return $this;
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setPlatformType(string $platformType): self {
        $this->platformType = $platformType;

        return $this;
    }

    public function setPlatformAddress(string $platformAddress): self {
        $this->platformAddress = $platformAddress;

        return $this;
    }

    public function setTags(\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordTagsCmd $tags): self {
        $this->tags = $tags;

        return $this;
    }

    public function setBudget(float $budget): self {
        $this->budget = $budget;

        return $this;
    }

    public function setStartAt(string $startAt): self {
        $this->startAt = $startAt;

        return $this;
    }

    public function setEndAt(string $endAt): self {
        $this->endAt = $endAt;

        return $this;
    }

    public function setLeaderStaffIds(array $leaderStaffIds): self {
        $this->leaderStaffIds = $leaderStaffIds;

        return $this;
    }

    public function setLeaderPhone(?string $leaderPhone): self {
        $this->leaderPhone = $leaderPhone;

        return $this;
    }

    public function setRecordStaffs(array $recordStaffs): self {
        $this->recordStaffs = $recordStaffs;

        return $this;
    }

    public function setPreferentialTypeList(array $preferentialTypeList): self {
        $this->preferentialTypeList = $preferentialTypeList;

        return $this;
    }

    public function setDiscount(?float $discount): self {
        $this->discount = $discount;

        return $this;
    }

    public function setNotes(string $notes): self {
        $this->notes = $notes;

        return $this;
    }

    public function setFiles(array $files): self {
        $this->files = $files;

        return $this;
    }
}