<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-12 11:02:09
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Product";

    /**
     * 创建产品
     *
     */
    public static function create (string $module, string $name, int $category_id, string $main_img, string $eng_name, string $full_name, int $mini_people_num, int $max_people_num, int $sort, int $occupy_value, bool $is_entity, bool $c_hidden, array $extend, int $photographic_num, int $photo_num, array $blacklist, string $comment, array $metadata, bool $can_upload_cloud, int $negative_num, int $set_num, array $retail_product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["module" => $module, "name" => $name, "category_id" => $category_id, "main_img" => $main_img, "eng_name" => $eng_name, "full_name" => $full_name, "mini_people_num" => $mini_people_num, "max_people_num" => $max_people_num, "sort" => $sort, "occupy_value" => $occupy_value, "is_entity" => $is_entity, "c_hidden" => $c_hidden, "extend" => $extend, "photographic_num" => $photographic_num, "photo_num" => $photo_num, "blacklist" => $blacklist, "comment" => $comment, "metadata" => $metadata, "can_upload_cloud" => $can_upload_cloud, "negative_num" => $negative_num, "set_num" => $set_num, "retail_product_ids" => $retail_product_ids, ]);
    }
    /**
     * 产品详情
     *
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 删除产品
     *
     */
    public static function delete (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id, ]);
    }
    /**
     * 2020圣诞照配置
     *
     */
    public static function christmasActivitySetting (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->christmasActivitySetting();
    }
    /**
     * 更新产品
     *
     */
    public static function update (int $id, string $module, string $name, int $category_id, string $main_img, string $eng_name, string $full_name, int $mini_people_num, int $max_people_num, int $sort, int $occupy_value, bool $is_entity, bool $c_hidden, array $extend, int $photographic_num, int $photo_num, array $blacklist, string $comment, array $retail_sku_infos, array $metadata, bool $can_upload_cloud, int $negative_num, int $set_num, array $retail_product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "module" => $module, "name" => $name, "category_id" => $category_id, "main_img" => $main_img, "eng_name" => $eng_name, "full_name" => $full_name, "mini_people_num" => $mini_people_num, "max_people_num" => $max_people_num, "sort" => $sort, "occupy_value" => $occupy_value, "is_entity" => $is_entity, "c_hidden" => $c_hidden, "extend" => $extend, "photographic_num" => $photographic_num, "photo_num" => $photo_num, "blacklist" => $blacklist, "comment" => $comment, "retail_sku_infos" => $retail_sku_infos, "metadata" => $metadata, "can_upload_cloud" => $can_upload_cloud, "negative_num" => $negative_num, "set_num" => $set_num, "retail_product_ids" => $retail_product_ids, ]);
    }
    /**
     * 产品列表
     *
     */
    public static function getProductList (int $category_id, string $name, string $full_name, bool $show_deleted, string $module, string $status, bool $c_hidden, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["category_id" => $category_id, "name" => $name, "full_name" => $full_name, "show_deleted" => $show_deleted, "module" => $module, "status" => $status, "c_hidden" => $c_hidden, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 全部产品列表
     *
     */
    public static function getAllProduct (int $category_id, string $name, string $full_name, bool $show_deleted, string $module, string $status, bool $c_hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProduct(["category_id" => $category_id, "name" => $name, "full_name" => $full_name, "show_deleted" => $show_deleted, "module" => $module, "status" => $status, "c_hidden" => $c_hidden, ]);
    }
    /**
     * 上架产品
     *
     */
    public static function upProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upProduct(["id" => $id, ]);
    }
    /**
     * 下架产品
     *
     */
    public static function downProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->downProduct(["id" => $id, ]);
    }
    /**
     * 获取全部服务组
     *
     */
    public static function serviceGroups () {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceGroups();
    }
    /**
     * 获取全部服务项
     *
     */
    public static function serviceLabels () {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceLabels();
    }
    /**
     * 添加服务组
     *
     */
    public static function addServiceGroup (string $name, string $eng_name, string $full_name, bool $multiple, bool $is_required, string $desc, array $extend, int $product_id, array $services) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceGroup(["name" => $name, "eng_name" => $eng_name, "full_name" => $full_name, "multiple" => $multiple, "is_required" => $is_required, "desc" => $desc, "extend" => $extend, "product_id" => $product_id, "services" => $services, ]);
    }
    /**
     * 编辑升级服务组
     *
     */
    public static function editServiceGroup (int $id, string $name, string $eng_name, string $full_name, bool $multiple, bool $is_required, string $comment, array $extend, int $product_id, array $services) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editServiceGroup(["id" => $id, "name" => $name, "eng_name" => $eng_name, "full_name" => $full_name, "multiple" => $multiple, "is_required" => $is_required, "comment" => $comment, "extend" => $extend, "product_id" => $product_id, "services" => $services, ]);
    }
    /**
     * 添加服务项
     *
     */
    public static function addServiceLabel (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceLabel(["name" => $name, ]);
    }
    /**
     * 产品全局折扣计算
     *
     */
    public static function productDiscountCalc (int $store_id, array $product_num_map) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDiscountCalc(["store_id" => $store_id, "product_num_map" => $product_num_map, ]);
    }
    /**
     * 修改extend
     *
     */
    public static function editExtend (int $id, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editExtend(["id" => $id, "extend" => $extend, ]);
    }
    /**
     * 设置预约端显示
     *
     */
    public static function editCHidden (int $id, bool $c_hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editCHidden(["id" => $id, "c_hidden" => $c_hidden, ]);
    }
    /**
     * 根据MODULE获取类目/产品树
     *
     */
    public static function getProductTreeByModules (array $module, string $status, bool $c_hidden, bool $is_entity, int $show_level) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByModules(["module" => $module, "status" => $status, "c_hidden" => $c_hidden, "is_entity" => $is_entity, "show_level" => $show_level, ]);
    }
    /**
     * 获取产品定时上下线时间
     *
     */
    public static function getCronUpDownTime (int $product_id): \Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCronUpDownTime(["product_id" => $product_id, ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO"
        );
    }
    /**
     * 设置定时上下线时间
     *
     */
    public static function setCronUpDownTime (int $product_id, string $up_time, string $down_time): \Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->setCronUpDownTime(["product_id" => $product_id, "up_time" => $up_time, "down_time" => $down_time, ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO"
        );
    }
    /**
     * 定时上下线活动
     *
     */
    public static function cronUpDownProduct (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->cronUpDownProduct();
    }
    /**
     * 添加产品禁用门店
     *
     */
    public static function addStoreToBlacklist (int $product_id, array $store_ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoreToBlacklist(["product_id" => $product_id, "store_ids" => $store_ids, ]);
    }
    /**
     * 获取产品禁用门店
     *
     */
    public static function getProductBlacklists (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductBlacklists(["product_id" => $product_id, ]);
    }
    /**
     * 设置产品预约截止时间
     *
     */
    public static function setAppointmentDeadline (int $product_id, string $deadline) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setAppointmentDeadline(["product_id" => $product_id, "deadline" => $deadline, ]);
    }
    /**
     * 产品拖拽排序
     *
     */
    public static function dragProduct (int $current_id, int $target_parent_id, int $target_sort): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->dragProduct(["current_id" => $current_id, "target_parent_id" => $target_parent_id, "target_sort" => $target_sort, ]);
    }
    /**
     * 获取产品占点
     *
     */
    public static function getProductsOccupy (array $product_group): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsOccupy(["product_group" => $product_group, ]);
    }
    /**
     * 复制产品
     *
     */
    public static function copyProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyProduct(["id" => $id, ]);
    }
    /**
     * 删除产品服务组
     *
     */
    public static function deleteProductServiceGroup (int $service_group_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteProductServiceGroup(["service_group_id" => $service_group_id, ]);
    }
    /**
     * 清理产品缓存
     *
     */
    public static function clearCache (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCache();
    }
    /**
     * 编辑推荐产品
     *
     */
    public static function editRecommendProduct (int $id, int $category_id, array $recommend, array $store_ids, array $ban_store_ids, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRecommendProduct(["id" => $id, "category_id" => $category_id, "recommend" => $recommend, "store_ids" => $store_ids, "ban_store_ids" => $ban_store_ids, "type" => $type, ]);
    }
    /**
     * 获取推荐产品/产品组
     *
     */
    public static function getRecommendProduct (int $category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRecommendProduct(["category_id" => $category_id, ]);
    }
    /**
     * 批量获取服务
     *
     */
    public static function getServiceByIds (array $service_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceByIds(["service_ids" => $service_ids, ]);
    }
    /**
     * 获取全产品宫格别名
     *
     */
    public static function getGonggeAlias () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGonggeAlias();
    }
    /**
     * 批量添加门店到产品黑名单
     *
     */
    public static function batchAddStoreToProductBlacklist (array $productIds, array $storeIds, string $blacklistHandleType): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAddStoreToProductBlacklist(["productIds" => $productIds, "storeIds" => $storeIds, "blacklistHandleType" => $blacklistHandleType, ]);
    }
    /**
     * 根据门店获取产品黑名单详情
     *
     */
    public static function getBlackListsByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBlackListsByStoreId(["storeId" => $storeId, ]);
    }
    /**
     * 下载门店获取产品黑名单详情
     *
     */
    public static function exportBlackListsByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportBlackListsByStoreId(["storeId" => $storeId, ]);
    }
    /**
     * 获取门店产品黑名单数量
     *
     */
    public static function getAllStoreBlackListCount (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreBlackListCount(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\StoreBlackDTO[]"
        );
    }
    /**
     * 根据品牌获取城市和价格区下的门店信息
     *
     */
    public static function getCityAndPriceAreaStoreInfosByBrand (string $module, string $store_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityAndPriceAreaStoreInfosByBrand(["module" => $module, "store_type" => $store_type, ]);
    }
    /**
     * 根据品牌获取城市下的门店信息
     *
     */
    public static function getCityStoreInfosByStoreTypes (array $storeTypes): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityStoreInfosByStoreTypes(["storeTypes" => $storeTypes, ]);
    }
    /**
     * 更新产品标签
     *
     */
    public static function updateProductTags (int $productId, array $tagIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductTags(["productId" => $productId, "tagIds" => $tagIds, ]);
    }
    /**
     * 获取产品价格区间最小值通过产品分类id
     *
     */
    public static function getProductPriceAreaMinByCategoryId (int $categoryId): \Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\ProductPriceAreaMinDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductPriceAreaMinByCategoryId(["categoryId" => $categoryId, ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\ProductPriceAreaMinDTO"
        );
    }
    /**
     * 得到修修兽产品sku下拉列表
     *
     */
    public static function getShowPicProductSkuList (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShowPicProductSkuList(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\ShowPicProductSelectDTO[]"
        );
    }
    /**
     * 获取产品类目下的所有可绑定零售
     *
     */
    public static function getRetailProducts (int $categoryId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailProducts(["categoryId" => $categoryId, ]);
    }
    /**
     * 获取产品服务组类型
     *
     */
    public static function getProductServiceGroupType (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductServiceGroupType();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}