<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-12 16:07:09
 */
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCard
 */
class GiftCard {
    private static string $serviceName = "HimoProduct";

    private static string $className = "User\\GiftCard";

    /**
     * 礼品卡列表
     *
     */
    public static function list (int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 用户购买礼品卡
     *
     */
    public static function createOrder (float $pay_money, array $card_item, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder(["pay_money" => $pay_money, "card_item" => $card_item, "extend" => $extend, ]);
    }
    /**
     * 获取用户礼品卡列表
     *
     */
    public static function ownList (string $type, string $sort_field, string $sort_direction) {
        return RpcClass::getClass(self::$serviceName, self::$className)->ownList(["type" => $type, "sort_field" => $sort_field, "sort_direction" => $sort_direction, ]);
    }
    /**
     * 获取用户礼品卡信息
     *
     */
    public static function info (): \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\Dto\UserGiftCardInfoDto {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->info(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\Dto\UserGiftCardInfoDto"
        );
    }
    /**
     * 获取礼品卡微信卡券
     *
     */
    public static function createWechatCard (string $code, string $open_id, string $scene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createWechatCard(["code" => $code, "open_id" => $open_id, "scene" => $scene, ]);
    }
    /**
     * 通过微信卡券返回码获取礼品卡信息
     *
     */
    public static function getCardByWechatCard (string $scene, string $encrypt_code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardByWechatCard(["scene" => $scene, "encrypt_code" => $encrypt_code, ]);
    }
    /**
     * 充值礼品卡并从微信卡包移除
     *
     */
    public static function bindFromWechat (string $code, string $scene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindFromWechat(["code" => $code, "scene" => $scene, ]);
    }
    /**
     * 绑定礼品卡(用于领取到微信卡包失败)
     *
     */
    public static function bindBack (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindBack(["code" => $code, ]);
    }
    /**
     * 获取用户可用封面信息
     *
     */
    public static function coverList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->coverList();
    }
    /**
     * 获取礼品卡类型信息
     *
     */
    public static function topicList (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->topicList(["id" => $id, ]);
    }
    /**
     * 获取预览信息
     *
     */
    public static function preview (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->preview(["code" => $code, ]);
    }
    /**
     * 设置cover
     *
     */
    public static function setCover (int $cover_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCover(["cover_id" => $cover_id, ]);
    }
    /**
     * 获取用户余额
     *
     */
    public static function balance () {
        return RpcClass::getClass(self::$serviceName, self::$className)->balance();
    }
    /**
     * 充值礼品码
     *
     */
    public static function charge (string $code): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->charge(["code" => $code, ]);
    }
    /**
     * 绑定礼品码(微信卡券未领取后)
     *
     */
    public static function bind (string $code, string $scene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bind(["code" => $code, "scene" => $scene, ]);
    }
    /**
     * 获取礼品卡订单列表
     *
     */
    public static function orderList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderList();
    }
    /**
     * 获取单个礼品卡订单详情
     *
     */
    public static function orderDetail (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderDetail(["order_num" => $order_num, ]);
    }
    /**
     * 获取礼品卡交易明细
     *
     */
    public static function transactionList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->transactionList();
    }
    /**
     * 获取礼品卡充值记录
     *
     */
    public static function chargeRecord () {
        return RpcClass::getClass(self::$serviceName, self::$className)->chargeRecord();
    }
    /**
     * 发送邀请链接
     *
     */
    public static function give (int $gift_card_id, string $title, string $words) {
        return RpcClass::getClass(self::$serviceName, self::$className)->give(["gift_card_id" => $gift_card_id, "title" => $title, "words" => $words, ]);
    }
    /**
     * 获取赠送详情
     *
     */
    public static function giveDetail (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giveDetail(["code" => $code, ]);
    }
    /**
     * 接受赠送
     *
     */
    public static function receiveGive (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveGive(["code" => $code, ]);
    }
    /**
     * 取消推送
     *
     */
    public static function cancelGive (int $card_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelGive(["card_id" => $card_id, ]);
    }
    /**
     * 确认推送
     *
     */
    public static function confirmGive (string $code, string $title, string $words) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmGive(["code" => $code, "title" => $title, "words" => $words, ]);
    }
    /**
     * 解密订单编码
     *
     */
    public static function decodeOrderNumCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->decodeOrderNumCode(["code" => $code, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}