<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method getOrderSurplusRefundListByParams(array $params)
 * @method detailByParams(array $params)
 */
class SurplusRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退款手续费退款
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  array $refundIds 需要退手续费的退款ID [ require true ]
     * @support  float $refundMoney 退款金额 [ require false ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 退款原因 [ require false ]
     * @support  array $reasonIds 原因Ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 手续费剩余退款列表
     *
     * @support  string $orderNo 主订单号 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  array $storeIds 门店IDs [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $statusList 状态array [ require false ]
     * @support  string $applyTimeStart 申请时间-开始 [ require false ]
     * @support  string $applyTimeEnd 申请时间-结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $pageSize  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取订单的可退手续费信息
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\SurplusRefund\Dto\OrderSurplusRefundListDto[]
     */
    public static function getOrderSurplusRefundList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderSurplusRefundList([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\SurplusRefund\Dto\OrderSurplusRefundListDto[]"
        );
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SurplusRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SurplusRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}