<?php
namespace Mainto\Bridge\Invokes\HimoProduct\BuyerShow;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method topicListByParams(array|\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\Topic\TopicListCmd $params)
 * @method getTopicByParams(array $params)
 * @method saveTopicByParams(array|\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\Topic\TopicCmd $params)
 */
class BuyerShowTopic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 话题列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\Topic\TopicListCmd $topicListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\Topic\TopicListDTO
     */
    public static function topicList (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\Topic\TopicListCmd $topicListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->topicList($topicListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\Topic\TopicListDTO"
        );
    }


    /**
     * 话题详情
     *
     * @param  int $topicId 话题ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\Topic\TopicDTO
     */
    public static function getTopic (int $topicId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTopic([
                            "topicId" => $topicId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\Topic\TopicDTO"
        );
    }

    /**
     * 保存话题
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\Topic\TopicCmd $topicCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveTopic (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\Topic\TopicCmd $topicCmd) {
        return self::getClass()->saveTopic($topicCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'BuyerShow\BuyerShowTopic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'BuyerShow\BuyerShowTopic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}