<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method batchUpByParams(array $params)
 * @method getBrandsByParams(array $params)
 * @method getChangeByParams(array $params)
 */
class ProductAudit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 审批产品列表
     *
     * @support  string $productName 产品名称 [ require false ]
     * @support  array $brands 品牌数组 [ require false ]
     * @support  string $type 类型：product/package [ require false ]
     * @support  bool $existAuditing 是否存在审批中状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 批量上线
     *
     * @support  array $productIds 产品id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUp () {
        return self::getClass()->batchUp([
        ]);
    }

    /**
     * 获取brands
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBrands () {
        return self::getClass()->getBrands();
    }

    /**
     * 获取审批中差异
     *
     * @param  int $productId 产品id [ require true ]
     * @param  string $processCode 审批编号 [ require false ]
     * @param  string $type 类型：product/package [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChange (int $productId, string $type, string $processCode = '') {
        return self::getClass()->getChange([
            "productId" => $productId,
            "type" => $type,
            "processCode" => $processCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductAudit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductAudit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}