<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method batchUpByParams(array $params)
 * @method getBrandsByParams(array $params)
 * @method getChangeByParams(array $params)
 * @method startUpdateByParams(array $params)
 * @method setStatusByParams(array $params)
 */
class ProductAudit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 审批产品列表
     *
     * @support  string $productName 产品/子套餐名称 [ require false ]
     * @support  array $brands 品牌数组 [ require false ]
     * @support  string $type 类型：product/package [ require false ]
     * @support  bool $existAuditing 是否存在审批中状态 [ require false ]
     * @support  string $status 产品状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 批量上线
     *
     * @param  array $productIds 产品id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUp (array $productIds) {
        return self::getClass()->batchUp([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取brands
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBrands () {
        return self::getClass()->getBrands();
    }

    /**
     * 获取审批中差异
     *
     * @param  array $productId 产品/子套餐id [ require true ]
     * @param  int $productAuditId 产品/套餐审批id [ require false ]
     * @param  string $brand 品牌 [ require true ]
     * @param  string $subtype PRODUCT_AUDIT_SUBTYPE [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChange (array $productId, string $brand, string $subtype, int $productAuditId = 0) {
        return self::getClass()->getChange([
            "productId" => $productId,
            "brand" => $brand,
            "subtype" => $subtype,
            "productAuditId" => $productAuditId,
        ]);
    }

    /**
     * 产品/子套餐修改备案
     *
     * @support  array $data 修改数据 [ require true ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $productId 产品/子套餐id [ require true ]
     * @support  string $fullName 产品/子套餐全称 [ require true ]
     * @support  string $subtype PRODUCT_AUDIT_SUBTYPE [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function startUpdate () {
        return self::getClass()->startUpdate([
        ]);
    }

    /**
     * 更新产品状态
     *
     * @param  string $after 状态 [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @param  string $type PRODUCT_AUDIT_SUBTYPE [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStatus (string $after, int $productId, string $type) {
        return self::getClass()->setStatus([
            "after" => $after,
            "productId" => $productId,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductAudit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductAudit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}