<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Campaign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initCampaignByParams(array $params)
 * @method previewCampaignTemplateByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCMD $params)
 * @method saveCampaignTemplateByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCMD $params)
 * @method publishCampaignTemplateByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPublishCMD $params)
 * @method getCampaignDetailByParams(array $params)
 * @method getCampaignListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $params)
 * @method updateCampaignStatusByParams(array $params)
 * @method campaignDeleteByParams(array $params)
 */
class Campaign {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 初始化活动
     *
     * @throws  \Exception
     * @return  int
     */
    public static function initCampaign () {
        return self::getClass()->initCampaign();
    }

    /**
     * 保存预览模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCMD $campaignPreviewCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function previewCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCMD $campaignPreviewCmd) {
        return self::getClass()->previewCampaignTemplate($campaignPreviewCmd);
    }


    /**
     * 保存模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCMD $campaignSaveCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCMD $campaignSaveCmd) {
        return self::getClass()->saveCampaignTemplate($campaignSaveCmd);
    }


    /**
     * 发布模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPublishCMD $campaignPublishCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function publishCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPublishCMD $campaignPublishCmd) {
        return self::getClass()->publishCampaignTemplate($campaignPublishCmd);
    }


    /**
     * 获取活动模版详情
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @param  string $versionStatus 活动模版状态 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDTO
     */
    public static function getCampaignDetail (int $campaignId, string $versionStatus = 'up') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCampaignDetail([
                            "campaignId" => $campaignId,
                            "versionStatus" => $versionStatus,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDTO"
        );
    }

    /**
     * 承接页活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO
     */
    public static function getCampaignList (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCampaignList($campaignListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO"
        );
    }


    /**
     * 承接页活动上下线
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @param  string $status 活动状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCampaignStatus (int $campaignId, string $status) {
        return self::getClass()->updateCampaignStatus([
            "campaignId" => $campaignId,
            "status" => $status,
        ]);
    }

    /**
     * 承接页活动删除
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function campaignDelete (int $campaignId) {
        return self::getClass()->campaignDelete([
            "campaignId" => $campaignId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Campaign\Campaign');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Campaign\Campaign');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}