<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchPagesByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $params)
 * @method searchListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $params)
 * @method detailByParams(array $params)
 * @method createOrEditByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $params)
 * @method cancelAuditByParams(array $params)
 * @method getActivityListByPreferentialTypeAndActivityTypeByParams(array $params)
 */
class ActivitiesRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 活动备案-列表(分页)
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordPageDto
     */
    public static function searchPages (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchPages($activitiesRecordSearchCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordPageDto"
        );
    }


    /**
     * 活动备案-列表(不分页)
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDto[]
     */
    public static function searchList (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchList($activitiesRecordSearchCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDto[]"
        );
    }


    /**
     * 活动备案-详情
     *
     * @support  int $activityRecordId 活动备案id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDetailDto
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDetailDto"
        );
    }

    /**
     * 活动备案-创建(修改)活动备案并发起审批
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $activitiesRecordAddCmd
     * @throws  \Exception
     * @return  array
     */
    public static function createOrEdit (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $activitiesRecordAddCmd) {
        return self::getClass()->createOrEdit($activitiesRecordAddCmd);
    }


    /**
     * 活动备案-撤回审批
     *
     * @support  int $activityRecordId 活动备案id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAudit () {
        return self::getClass()->cancelAudit([
        ]);
    }

    /**
     * 活动备案-获取指定券码类型的活动
     *
     * @support  string $preferentialType 券码类型 [ require true ]
     * @support  string $activityType 活动类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityPassListDto[]
     */
    public static function getActivityListByPreferentialTypeAndActivityType () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityListByPreferentialTypeAndActivityType([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityPassListDto[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Marketing\ActivitiesRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Marketing\ActivitiesRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}