<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Tmp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQuestionByParams(array $params)
 * @method getMedalNumByParams(array $params)
 * @method answerQuestionByParams(array $params)
 * @method drawAwardByParams(array $params)
 * @method sendAwardByParams(array $params)
 * @method sendNoticeOneByParams(array $params)
 * @method sendNoticeTwoByParams(array $params)
 * @method sendNoticeThreeByParams(array $params)
 * @method addMedalNumByParams(array $params)
 * @method importAnswerByParams(array $params)
 */
class JiGuangActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取问题
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $date 日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQuestion (int $staffId, string $date = '2022-11-11 12:00:00') {
        return self::getClass()->getQuestion([
            "staffId" => $staffId,
            "date" => $date,
        ]);
    }

    /**
     * 获取奖章数
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMedalNum (int $staffId) {
        return self::getClass()->getMedalNum([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 回答问题
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $answer 答案 [ require true ]
     * @param  int $key 序号 [ require true ]
     * @param  string $date 日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function answerQuestion (int $staffId, string $answer, int $key, string $date = '2022-11-11 12:00:00') {
        return self::getClass()->answerQuestion([
            "staffId" => $staffId,
            "answer" => $answer,
            "key" => $key,
            "date" => $date,
        ]);
    }

    /**
     * 抽奖
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $date 日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function drawAward (int $staffId, string $date = '2022-11-11 12:00:00') {
        return self::getClass()->drawAward([
            "staffId" => $staffId,
            "date" => $date,
        ]);
    }

    /**
     * 2023-01-01 00:00:00开奖
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendAward () {
        return self::getClass()->sendAward();
    }

    /**
     * 每周五推送极光之星活动消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNoticeOne () {
        return self::getClass()->sendNoticeOne();
    }

    /**
     * 每周五推送极光之星活动消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNoticeTwo () {
        return self::getClass()->sendNoticeTwo();
    }

    /**
     * 每周五推送极光之星活动消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNoticeThree () {
        return self::getClass()->sendNoticeThree();
    }

    /**
     * addMedalNum
     *
     * @param  int $id 起始id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addMedalNum (int $id) {
        return self::getClass()->addMedalNum([
            "id" => $id,
        ]);
    }

    /**
     * importAnswer
     *
     * @param  string $name 正确答案产品名 [ require true ]
     * @param  string $imgPath 正确答案图片地址 [ require true ]
     * @param  int $peopleCount 正确回答的人数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function importAnswer (string $name, string $imgPath, int $peopleCount) {
        return self::getClass()->importAnswer([
            "name" => $name,
            "imgPath" => $imgPath,
            "peopleCount" => $peopleCount,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Tmp\JiGuangActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Tmp\JiGuangActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}