<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getValidPackageTreeByParams(array|\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetValidPackageTreeCmd $params)
 */
class Package {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取套餐树
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetValidPackageTreeCmd $getValidPackageTreeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Product\DTO\PackageDTO[]
     */
    public static function getValidPackageTree (\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetValidPackageTreeCmd $getValidPackageTreeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getValidPackageTree($getValidPackageTreeCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Product\DTO\PackageDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Product\Package');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Product\Package');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}