<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllStoreByParams(array|\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresCmd $params)
 * @method getAllAreasByParams(array|\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetAllAreasCmd $params)
 * @method getPriceAreasByParams(array|\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetPriceAreasCmd $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有门店
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresCmd $getStoresCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Store\DTO\StoreDTO[]
     */
    public static function getAllStore (\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresCmd $getStoresCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllStore($getStoresCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\StoreDTO[]"
        );
    }


    /**
     * 获取所有城市（省市区，不包含街道）
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetAllAreasCmd $getAllAreasCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Store\DTO\AreaDTO[]
     */
    public static function getAllAreas (\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetAllAreasCmd $getAllAreasCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllAreas($getAllAreasCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\AreaDTO[]"
        );
    }


    /**
     * 获取门店价格区
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetPriceAreasCmd $getPriceAreasCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Store\DTO\StorePriceAreaDTO[]
     */
    public static function getPriceAreas (\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetPriceAreasCmd $getPriceAreasCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPriceAreas($getPriceAreasCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\StorePriceAreaDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}