<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 */
class GiftCardTopic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建礼品卡主题
     *
     * @support  string $title 主题标题 [ require true ]
     * @support  string $img_path 主题封面图 [ require true ]
     * @support  int $sequence 排序值 [ require false ]
     * @support  int $series_id 系列id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新礼品卡主题
     *
     * @support  int $id id [ require true ]
     * @support  string $img_path 主题封面图 [ require false ]
     * @support  int $series_id 系列id [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  int $sequence 排序值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 获取单条礼品卡主题信息
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCardTopic\DTO\GiftCardTopicDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCardTopic\DTO\GiftCardTopicDTO"
        );
    }

    /**
     * 获取礼品卡主题列表(分页)
     *
     * @support  int $series_id 系列id [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @support  bool $has_series_info 是否包含系列信息 [ require false ]
     * @support  bool $has_covers_info 是否包含卡面信息 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCardTopic\DTO\GiftCardTopicPagesDTO
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCardTopic\DTO\GiftCardTopicPagesDTO"
        );
    }

    /**
     * 获取礼品卡主题列表(全部)
     *
     * @support  int $series_id 系列ids [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  bool $has_series_info 是否包含系列信息 [ require false ]
     * @support  bool $has_covers_info 是否包含卡面信息 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCardTopic\DTO\GiftCardTopicDTO[]
     */
    public static function all () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCardTopic\DTO\GiftCardTopicDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GiftCardTopic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GiftCardTopic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}