<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method abolishByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method allCreateLogByParams(array $params)
 * @method searchByParams(array $params)
 * @method balanceByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡作废
     *
     * @support  array $card_ids 卡ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolish () {
        return self::getClass()->abolish([
        ]);
    }

    /**
     * 获取礼品卡信息
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取礼品卡列表(分页)
     *
     * @support  int $id 礼品卡id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @support  bool $with_cover_info 是否包含卡面信息 [ require false ]
     * @support  int $create_log_id 生成记录id [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取创建日志列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function allCreateLog () {
        return self::getClass()->allCreateLog();
    }

    /**
     * 搜索礼品卡
     *
     * @support  int $id 礼品卡编号 [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @support  string $status 查询状态inactivated(未激活)|activated(已激活)|used(已使用)|abolished(已作废)|expired(已过期) [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  int $page 分页 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search () {
        return self::getClass()->search([
        ]);
    }

    /**
     * 获取用户礼品卡余额
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function balance (int $user_id) {
        return self::getClass()->balance([
            "user_id" => $user_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}