<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateStatusByParams(array $params)
 */
class HappyPhotoWish {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 心愿列表.心愿
     *
     * @support  string $startDay 开始日期 [ require false ]
     * @support  string $endDay 结束日期 [ require false ]
     * @support  string $phone 手机账号 [ require false ]
     * @support  string $status 实现状态 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\HappyPhotoWish\DTO\HappyPhotoWishPageDTO
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\HappyPhotoWish\DTO\HappyPhotoWishPageDTO"
        );
    }

    /**
     * 心愿删除.心愿
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 心愿实现.心愿
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStatus () {
        return self::getClass()->updateStatus([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\HappyPhotoWish');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\HappyPhotoWish');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}