<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method uploadByParams(array $params)
 * @method getUploadInfoByParams(array $params)
 * @method listByParams(array $params)
 * @method updateUpdatedAtByIdsByParams(array $params)
 * @method openNextBatchByParams(array $params)
 * @method auditByParams(array $params)
 * @method areaSelectByParams(array $params)
 * @method getStaffRoleAuthByParams(array $params)
 * @method messageRemindingByParams(array $params)
 * @method overdueRemoveByParams(array $params)
 */
class UnreviewedGuestPhotos {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权通过，加入客片审核中
     *
     * @support  int $store_id 店铺id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  array $images 图片数据[[&#039;photo_id&#039;=&gt;1,&#039;product_id&#039;=&gt;123,&#039;photo_url&#039;=&gt;&#039;123.jgp&#039;],[&#039;photo_id&#039;=&gt;2,&#039;product_id&#039;=&gt;123,&#039;photo_url&#039;=&gt;&#039;123.jgp&#039;]] [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadResDto
     */
    public static function upload () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->upload([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadResDto"
        );
    }

    /**
     * 返回已经上传的客片信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadInfoDto
     */
    public static function getUploadInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUploadInfo([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadInfoDto"
        );
    }

    /**
     * 获取客片审核列表
     *
     * @support  array $product_ids 产品ids [ require false ]
     * @support  int $area_id 区域id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UnreviewedGuestPhotoListDto
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UnreviewedGuestPhotoListDto"
        );
    }

    /**
     * 更新客片更新时间
     *
     * @support  array $ids 客片ids [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function updateUpdatedAtByIds () {
        return self::getClass()->updateUpdatedAtByIds([
        ]);
    }

    /**
     * 开启下一批审核
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function openNextBatch () {
        return self::getClass()->openNextBatch();
    }

    /**
     * 客片批量审核
     *
     * @support  array $ids 客片ids [ require true ]
     * @support  array $tags 标签ids [ require false ]
     * @support  string $result 结果[pass, not_pass] [ require true ]
     * @support  bool $is_photography_action 是否加入摄影动作(true 加入，false不加入) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function audit () {
        return self::getClass()->audit([
        ]);
    }

    /**
     * 客片审核区域下拉数据
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\SelectDto[]
     */
    public static function areaSelect () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->areaSelect(),
            "\Mainto\Bridge\Structs\HimoProduct\SelectDto[]"
        );
    }

    /**
     * 得到当前用户角色权限
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\StaffRoleAuthDto
     */
    public static function getStaffRoleAuth () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStaffRoleAuth(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\StaffRoleAuthDto"
        );
    }

    /**
     * 每天10点执行
     * 需要完成的任务：
     * 1. 检查督导的钉钉提醒
     * 2. 专家的钉钉提醒
     *
     * @throws  \Exception
     * @return  void
     */
    public static function messageReminding () {
        return self::getClass()->messageReminding();
    }

    /**
     * 逾期移除,每天0点0分1秒执行一次
     *
     * @throws  \Exception
     * @return  void
     */
    public static function overdueRemove () {
        return self::getClass()->overdueRemove();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}