<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserPortraitListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\Cmd\GetUserPortraitListCmd $params)
 * @method getAllUserPortraitListByParams(array $params)
 */
class UserPortrait {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户画像列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\Cmd\GetUserPortraitListCmd $getUserPortraitListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\DTO\UserPortraitListDTO
     */
    public static function getUserPortraitList (\Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\Cmd\GetUserPortraitListCmd $getUserPortraitListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserPortraitList($getUserPortraitListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\DTO\UserPortraitListDTO"
        );
    }


    /**
     * 获取所有的用户画像
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\DTO\UserPortraitDTO[]
     */
    public static function getAllUserPortraitList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllUserPortraitList(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UserPortrait\DTO\UserPortraitDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\UserPortrait');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\UserPortrait');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}