<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateMobileByParams(array $params)
 * @method getUserByPhoneByParams(array $params)
 * @method getUserByIdByParams(array $params)
 * @method logoutAndChangeMobileByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加一条用户信息
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 用户性别(male男|female女) [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\User\DTO\UserDTO
     */
    public static function create () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\User\DTO\UserDTO"
        );
    }

    /**
     * 修改用户手机
     *
     * @support  string $new_phone 新手机号 [ require false ]
     * @support  string $old_phone 旧手机号 [ require false ]
     * @support  string $code 验证码 [ require false ]
     * @support  string $certificate 用户沟通凭证 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateMobile () {
        return self::getClass()->updateMobile([
        ]);
    }

    /**
     * 注意：隐含了创建...没有用户就自动注册一个
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @support  string $phone 用户手机号 [ require true ]
     * @support  string $apply_in 用户手机号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\User\DTO\UserDTO
     */
    public static function getUserByPhone () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserByPhone([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\User\DTO\UserDTO"
        );
    }

    /**
     * 注意：隐含了创建...没有用户就自动注册一个
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\User\DTO\UserDTO
     */
    public static function getUserById (int $user_id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserById([
                            "user_id" => $user_id,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\User\DTO\UserDTO"
        );
    }

    /**
     * 注销并修改手机号
     *
     * @support  string $new_phone 新手机号 [ require false ]
     * @support  string $old_phone 旧手机号 [ require false ]
     * @support  string $code 验证码 [ require false ]
     * @support  string $certificate 用户沟通凭证 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function logoutAndChangeMobile () {
        return self::getClass()->logoutAndChangeMobile([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}