<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method refundRejectByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundRejectCmd $params)
 * @method refundSuccessByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundSuccessCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundListCmd $params)
 * @method detailByParams(array $params)
 */
class GroupOrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款拒绝
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundRejectCmd $command
     * @throws  \Exception
     * @return  bool
     */
    public static function refundReject (\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundRejectCmd $command) {
        return self::getClass()->refundReject($command);
    }


    /**
     * 退款同意
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundSuccessCmd $command
     * @throws  \Exception
     * @return  bool
     */
    public static function refundSuccess (\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundSuccessCmd $command) {
        return self::getClass()->refundSuccess($command);
    }


    /**
     * 团购订单退款列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundListCmd $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundListWithPageDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundListCmd $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundListWithPageDTO"
        );
    }


    /**
     * 团购订单退款单详情
     *
     * @param  int $refundGroupOrderId 团购订单退款id [ require true ]
     * @param  bool $withDeleted 需要查询已删除 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundDetailDTO
     */
    public static function detail (int $refundGroupOrderId, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "refundGroupOrderId" => $refundGroupOrderId,
                            "withDeleted" => $withDeleted,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GroupOrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GroupOrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}