<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPricesByParams(array|\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesCmd $params)
 */
class ProductPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品价格
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesCmd $getPricesCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Product\DTO\ProductPriceDTO[]
     */
    public static function getPrices (\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesCmd $getPricesCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPrices($getPricesCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Product\DTO\ProductPriceDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Product\ProductPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Product\ProductPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}