<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method refreshTokenByParams(array $params)
 * @method createTicketByParams(array $params)
 * @method addTicketEvaluationByParams(array $params)
 * @method ticketCallbackByParams(array $params)
 * @method getSatisfactionLevelLabelsByParams(array $params)
 * @method createSatisfactionByParams(array $params)
 */
class ZhiChi {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天早上9点喝24点刷新
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshToken () {
        return self::getClass()->refreshToken();
    }

    /**
     * 创建工单
     *
     * @param  int $share_order_id 晒单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createTicket (int $share_order_id) {
        return self::getClass()->createTicket([
            "share_order_id" => $share_order_id,
        ]);
    }

    /**
     * 提交工单满意度
     *
     * @param  string $ticket_id 工单id [ require true ]
     * @param  int $score 评分 [ require true ]
     * @param  bool $is_willing 是否继续相信海马体 [ require true ]
     * @param  string $remark 评语 [ require false ]
     * @param  array $labels 标记 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addTicketEvaluation (string $ticket_id, int $score, bool $is_willing, string $remark = '', array $labels = []) {
        return self::getClass()->addTicketEvaluation([
            "ticket_id" => $ticket_id,
            "score" => $score,
            "is_willing" => $is_willing,
            "remark" => $remark,
            "labels" => $labels,
        ]);
    }

    /**
     * 工单消息回调
     *
     * @support  string $sys_code 产品编码 [ require true ]
     * @support  string $type 消息类型 [ require true ]
     * @support  array $content 消息内容 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function ticketCallback () {
        return self::getClass()->ticketCallback([
        ]);
    }

    /**
     * 获取满意度的标签
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSatisfactionLevelLabels () {
        return self::getClass()->getSatisfactionLevelLabels();
    }

    /**
     * 创建满意度工单
     *
     * @param  string $ticket_source 满意度渠道来源 [ require true ]
     * @param  string $ticket_code 关联ID [ require true ]
     * @param  string $user_phone 用户手机号码 [ require true ]
     * @param  array $extend 扩展字段 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createSatisfaction (string $ticket_source, string $ticket_code, string $user_phone, array $extend) {
        return self::getClass()->createSatisfaction([
            "ticket_source" => $ticket_source,
            "ticket_code" => $ticket_code,
            "user_phone" => $user_phone,
            "extend" => $extend,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\ZhiChi');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\ZhiChi');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}