<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPricesByCategoryByParams(array|\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesByCategoryCmd $params)
 * @method getPricesByPackageByParams(array|\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesByPackageCmd $params)
 */
class ProductPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过产品组ID获取子产品价格列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesByCategoryCmd $getPricesByCategoryCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Product\DTO\PriceDTO[]
     */
    public static function getPricesByCategory (\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesByCategoryCmd $getPricesByCategoryCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPricesByCategory($getPricesByCategoryCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Product\DTO\PriceDTO[]"
        );
    }


    /**
     * 通过套餐ID获取子套餐价格列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesByPackageCmd $getPricesByPackageCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Product\DTO\PriceDTO[]
     */
    public static function getPricesByPackage (\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesByPackageCmd $getPricesByPackageCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPricesByPackage($getPricesByPackageCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Product\DTO\PriceDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Product\ProductPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Product\ProductPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}