<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getValidProductTreeByParams(array|\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetValidProductTreeCmd $params)
 * @method getPricesByParams(array|\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesCmd $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品树
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetValidProductTreeCmd $getValidProductTreeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Product\DTO\ProductDTO[]
     */
    public static function getValidProductTree (\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetValidProductTreeCmd $getValidProductTreeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getValidProductTree($getValidProductTreeCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Product\DTO\ProductDTO[]"
        );
    }


    /**
     * 获取产品价格
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesCmd $getPricesCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Product\DTO\ProductPriceDTO[]
     */
    public static function getPrices (\Mainto\Bridge\Structs\HimoProduct\Product\Cmd\GetPricesCmd $getPricesCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPrices($getPricesCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Product\DTO\ProductPriceDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}