<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method configWorkHourByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\ConfigWorkHourCmd $params)
 * @method configWorkHourConfigByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\ConfigWorkHourConfigCmd $params)
 * @method workHourDetailByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\WorkHourDetailCmd $params)
 * @method workHourConfigListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\WorkHourConfigListCmd $params)
 */
class WorkHour {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 配置产品工时
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\ConfigWorkHourCmd $configWorkHourCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function configWorkHour (\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\ConfigWorkHourCmd $configWorkHourCmd) {
        return self::getClass()->configWorkHour($configWorkHourCmd);
    }


    /**
     * 配置工时变量
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\ConfigWorkHourConfigCmd $configWorkHourConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function configWorkHourConfig (\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\ConfigWorkHourConfigCmd $configWorkHourConfigCmd) {
        return self::getClass()->configWorkHourConfig($configWorkHourConfigCmd);
    }


    /**
     * 产品工时详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\WorkHourDetailCmd $workHourDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\DTO\WorkHourDTO[]
     */
    public static function workHourDetail (\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\WorkHourDetailCmd $workHourDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->workHourDetail($workHourDetailCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\DTO\WorkHourDTO[]"
        );
    }


    /**
     * 工时配置列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\WorkHourConfigListCmd $workHourConfigListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\DTO\WorkHourConfigDTO[]
     */
    public static function workHourConfigList (\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\Cmd\WorkHourConfigListCmd $workHourConfigListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->workHourConfigList($workHourConfigListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\WorkHour\DTO\WorkHourConfigDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\WorkHour');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\WorkHour');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}