<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoresByAreaIdByParams(array|\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresByAreaIdCmd $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有门店
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresByAreaIdCmd $getStoresByAreaIdCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Store\DTO\StoreDTO[]
     */
    public static function getStoresByAreaId (\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresByAreaIdCmd $getStoresByAreaIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoresByAreaId($getStoresByAreaIdCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\StoreDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}