<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method calcRefundInfoByOrderItemsByParams(array $params)
 * @method createV2ByParams(array $params)
 * @method confirmV2ByParams(array $params)
 * @method createAndConfirmV2ByParams(array $params)
 * @method fixDubiousRefundResultByParams(array $params)
 * @method fixRefundAccountByParams(array $params)
 * @method detailByParams(array $params)
 * @method doubtSuccessByParams(array $params)
 * @method doubtErrorByParams(array $params)
 * @method doubtErrorToSuccessByParams(array $params)
 * @method manualSuccessByParams(array $params)
 * @method refuseByParams(array $params)
 * @method reasonByParams(array $params)
 * @method fastRefundToGiftCardByParams(array $params)
 * @method canRefundDetailByIdsByParams(array $params)
 * @method confirmHandRefundByParams(array $params)
 * @method getOrderRefundInfoByParams(array $params)
 * @method afterRefundForPlatformByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款列表
     *
     * @support  string $order_no 主订单号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  string $status_list 状态组(,拼接) [ require false ]
     * @support  int $store_id 门店ID [ require false ]
     * @support  array $store_ids 门店ID [ require false ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  string $apply_time_start 申请时间-开始 [ require false ]
     * @support  string $apply_time_end 申请时间-结束 [ require false ]
     * @support  string $process_time_start 处理时间-开始 [ require false ]
     * @support  string $process_time_end 处理时间-结束 [ require false ]
     * @support  string $complete_time_start 退款完成时间-开始 [ require false ]
     * @support  string $complete_time_end 退款完成时间-结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 根据订单的拍摄产品获取可退信息
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $refundType 类型 [ require false ]
     * @support  array $refundInfo 退款项 [ require true ]
     * @support  bool $withDelete 是否包含删除的订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calcRefundInfoByOrderItems () {
        return self::getClass()->calcRefundInfoByOrderItems([
        ]);
    }

    /**
     * 退款申请v2
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $refundType 退款类型 [ require false ]
     * @support  int $scale 退款比例 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款原因 [ require false ]
     * @support  array $reasonIds 退款ids [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  array $refundInfo 退款项 [ require true ]
     * @support  bool $withDelete 是否包含删除的订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createV2 () {
        return self::getClass()->createV2([
        ]);
    }

    /**
     * 退款处理V2
     *
     * @param  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmV2 (int $id) {
        return self::getClass()->confirmV2([
            "id" => $id,
        ]);
    }

    /**
     * 退款申请并退款v2
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $refundType 退款类型 [ require false ]
     * @support  int $scale 退款比例 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款原因 [ require false ]
     * @support  array $reasonIds 退款ids [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  array $refundInfo 退款项 [ require false ]
     * @support  bool $withDelete 是否包含删除的订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAndConfirmV2 () {
        return self::getClass()->createAndConfirmV2([
        ]);
    }

    /**
     * 对待确认的错误退款进行修正
     *
     * @param  int $id 退款ID [ require true ]
     * @param  float $auto_real_money 自动退款金额 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fixDubiousRefundResult (int $id, float $auto_real_money) {
        return self::getClass()->fixDubiousRefundResult([
            "id" => $id,
            "auto_real_money" => $auto_real_money,
        ]);
    }

    /**
     * 支持修改收款人姓名、收款人账户（支付宝账户）不填则不修改
     *
     * @support  int $id 退款ID [ require true ]
     * @support  string $people 退款人 [ require false ]
     * @support  string $account 退款账户 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixRefundAccount () {
        return self::getClass()->fixRefundAccount([
        ]);
    }

    /**
     * 退款详情
     *
     * @param  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 存疑自动退款-改为已退
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款金额详情的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function doubtSuccess (int $refundId, int $refundMoneyDetailId) {
        return self::getClass()->doubtSuccess([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
        ]);
    }

    /**
     * 存疑自动退款-改为未退
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款金额详情的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function doubtError (int $refundId, int $refundMoneyDetailId) {
        return self::getClass()->doubtError([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
        ]);
    }

    /**
     * 存疑自动退款未退订单-改为已退
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款金额详情的id [ require true ]
     * @param  string $paymentNo 支付宝凭证号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function doubtErrorToSuccess (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return self::getClass()->doubtErrorToSuccess([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 手动退款订单-标记为已处理
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款金额详情的id [ require true ]
     * @param  string $paymentNo 支付宝凭证号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function manualSuccess (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return self::getClass()->manualSuccess([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @support  int $id 退款id [ require false ]
     * @support  string $reason 拒绝理由 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuse () {
        return self::getClass()->refuse([
        ]);
    }

    /**
     * 退款理由
     *
     * @support  string $category 分类：category_user_refund,category_admin_refund [ require false ]
     * @support  int $parent_id  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason([
        ]);
    }

    /**
     * 快速退款至礼品卡
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $refund_type 退款类型 [ require false ]
     * @support  array $refund_info 退款项 [ require false ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fastRefundToGiftCard () {
        return self::getClass()->fastRefundToGiftCard([
        ]);
    }

    /**
     * 获取部分子订单项可退金额
     *
     * @support  int $order_id 订单ID [ require true ]
     * @support  array $refund_info 待退款项 [ require true ]
     * @support  string $refund_type 退款类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundDetailByIds () {
        return self::getClass()->canRefundDetailByIds([
        ]);
    }

    /**
     * 手动退款再次确认
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmHandRefund (int $id) {
        return self::getClass()->confirmHandRefund([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单退款信息
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderRefundInfo (string $order_no) {
        return self::getClass()->getOrderRefundInfo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 接收预约端退款消息
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  float $oldRefundMoney 需要扣除的退款金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function afterRefundForPlatform (int $refundId, float $oldRefundMoney) {
        return self::getClass()->afterRefundForPlatform([
            "refundId" => $refundId,
            "oldRefundMoney" => $oldRefundMoney,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}