<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method orderListByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method detailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method getCustomerPhotoAuthStatusByParams(array $params)
 * @method resetPhotoAuthByParams(array $params)
 */
class CustomerPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 客片已授权列表
     *
     * @support  string $user_phone 手机号 [ require false ]
     * @support  string $order_num 订单编号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 待授权列表
     *
     * @support  string $user_phone 手机号 [ require false ]
     * @support  string $order_num 订单编号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderList () {
        return self::getClass()->orderList([
        ]);
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  string $invite_from 邀请来源 [ require false ]
     * @support  int $staff_id 员工ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice([
        ]);
    }

    /**
     * 授权详情
     *
     * @support  int $id 授权id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 取消授权
     *
     * @support  int $id 授权编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel([
        ]);
    }

    /**
     * 获取授权信息(RPC调用 用于看片师授权)
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCustomerPhotoAuthStatus (string $orderNum) {
        return self::getClass()->getCustomerPhotoAuthStatus([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 重置授权信息(RPC调用 用于看片师授权)
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetPhotoAuth (string $orderNum, int $staffId) {
        return self::getClass()->resetPhotoAuth([
            "orderNum" => $orderNum,
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\CustomerPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\CustomerPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}